function [growthparams, e1, e2, theta] = gtlib_svd2growthparams(g1, g2, t)
% function growthparams = gtlib_svd2growthparams(g1, g2, t)
%
% 
% before we would have done
% smax = 1/S(1,1);
% smin = 1/S(2,2);
% H = (1./smax).*(1./smin);
% G = t.*((log(2))./(log(H)));
% A = ((1./smax)./(1./smin)).^(G./t);
% 
% and then returned [G, A, theta], and then we would have used
% 
% doublex = sqrt(2*A);
% doubley = doublex/A;
% rate_x = log2(doublex)/G;
% rate_y = log2(doubley)/G;
% 
% to calculate the stretch ratios we now calculate these stretch ratios from the principle strains (e1, e2) by the fact that
% log2(e1)/t = log2(sqrt(2*A))/G
% 
% Proof:
% 
% log2(e1)/t = log2(sqrt(2A))/G
%            = (log2(sqrt(2)) + log2(sqrt(A)))/G
%            = (0.5 + 0.5*log2(A))/G
%            = (0.5 + 0.5*log2((e1/e2)^(G/t)))/G
%            = (0.5 + (G/(2*t))*log2(e1/e2))/G
%            = 1/(2*G) + (1/(2*t))*log2(e1/e2)
%            = 1/(2*G) + (1/(2*t))*(log2(e1) - log2(e2))
%            = (log2(H) + log2(e1) - log2(e2))/(2*t)
%            = (log2(e1) + log2(e2) + log2(e1) - log2(e2))/(2*t)
%            = log2(e1)/t.
%           
% In a similar way we can prove that
% 
% log2(e2)/t = log2(sqrt(2*A)/A)/G
%            
% and so our stretch ratios are given as
% 
% [log2(S(1,1))/t, log2(S(2,2))/t, theta]
%
% Dr. A. I. Hanna (2007)
T = inv(g1'*g1)*(g1'*g2);
T = (T + T')/2;
[U, S, V] = svd(T);
e1 = S(1,1);
e2 = S(2,2);
theta = atan(U(2,1)/U(1,1));
if nargin<3
    t = 20;
end
growthparams = [log2(e1)/t, log2(e2)/t, theta];
return

%%%%%%%%%%%%%%%%%
%%% OLD CODE%%%%%
%%%%%%%%%%%%%%%%%
% % Usually we would calculate this here
% smax = 1/S(1,1);
% smin = 1/S(2,2);
% H = (1./smax).*(1./smin);
% G = t.*((log(2))./(log(H)));
% A = ((1./smax)./(1./smin)).^(G./t);
% 
% % And then do this in another function to pass to growthParams2Tensor
% doublex = sqrt(2*A);
% doubley = doublex/A;
% rate_x = log2(doublex)/G;
% rate_y = log2(doubley)/G;
% [rate_x, rate_y, theta];
% growthparams = [G, A, theta];
% return;