function varargout = gtlib_plotGrowthTensorCross(varargin)
% function varargout = gtlib_plotGrowthTensorCross(varargin)
%
% A function that draws the growth tensor cross, input parameters are
%
% 'growth_tensor' - a 3x3 growth tensor
% 'offset' - a 2x1 vector with an x & y offset
% 'colour' - the colour of the edge of the tensor
% 'Parent' - the handle of the axis where to draw the tensor
% 'scale' - the scale of the tensor
%
% Returns the plot handle to the tensor
%
% See also: gtlib_plotGrowthTensor
%
% Dr. A. I. Hanna (2007)
error(nargchk(0,inf,nargin));
ungrowthfilename = [];
scale = 1;
if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error('%s %s %s', 'Arguments to', mfilename, 'must come param/value in pairs.')
end
offset = [0 0];
scale = 1;
col = [0 1 0];
axis_handle = [];
linwidth = 1;
GT = [];
ph = [];
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'growth_tensor'
            GT = varargin{i+1};
        case 'offset'
            offset = varargin{i+1};
        case 'colour'
            col = varargin{i+1};
        case 'linewidth'
            linwidth = varargin{i+1};
        case 'parent'
            axis_handle = varargin{i+1};
        case 'scale'
            scale = varargin{i+1};
        otherwise
            error('%s\n%s %s', 'Unknown parameter name passed to show_region_areal_growth.', 'Name was', varargin{i});
    end
end
if isempty(GT)
    error('%s %s %s', 'Error ==>', mfilename, 'must have a growth tensor');
end
if isempty(axis_handle)
    axis_handle = gca;
end
% [V, L] = eig(GT);
% [L, ind] = sort(diag(L), 'descend');
% V = V(:, ind);
% 
% p1 = scale*L(1)*V(:,1);
% p2 = scale*L(2)*V(:,2);
% 
% %p1 = GT*[scale;0;0];
% %p2 = GT*[0;scale;0];
% ph = [];
% ph = cat(2, ph, plot(axis_handle, [offset(1) offset(1) + p1(1)], [offset(2) offset(2) + p1(2)], 'Color', col));
% ph = cat(2, ph, plot(axis_handle, [offset(1) offset(1) - p1(1)], [offset(2) offset(2) - p1(2)], 'Color', col));
% ph = cat(2, ph, plot(axis_handle, [offset(1) offset(1) + p2(1)], [offset(2) offset(2) + p2(2)], 'Color', col));
% ph = cat(2, ph, plot(axis_handle, [offset(1) offset(1) - p2(1)], [offset(2) offset(2) - p2(2)], 'Color', col));
% varargout{1} = ph;


[major, minor, theta] = gtlib_growthTensor2Params(GT);
x = scale*major*cos(theta);
y = scale*major*sin(theta);
ph = [];
ph = cat(2, ph, plot(axis_handle, [offset(1) offset(1) + x], [offset(2) offset(2) + y], 'Color', col, 'LineWidth', linwidth));
ph = cat(2, ph, plot(axis_handle, [offset(1) offset(1) - x], [offset(2) offset(2) - y], 'Color', col, 'LineWidth', linwidth));
x = scale*minor*(-sin(theta));
y = scale*minor*cos(theta);
ph = cat(2, ph, plot(axis_handle, [offset(1) offset(1) + x], [offset(2) offset(2) + y], 'Color', col, 'LineWidth', linwidth));
ph = cat(2, ph, plot(axis_handle, [offset(1) offset(1) - x], [offset(2) offset(2) - y], 'Color', col, 'LineWidth', linwidth));
set(ph, 'HitTest', 'off');
varargout{1} = ph;
return;