function varargout = gtlib_plotGrowthTensor(varargin)
% function varargout = gtlib_plotGrowthTensor(varargin)
%
% A function that draws the growth tensor, input parameters are
%
% 'growth_tensor' - a 3x3 growth tensor
% 'offset' - a 2x1 vector with an x & y offset
% 'colour' - the colour of the edge of the tensor
% 'Parent' - the handle of the axis where to draw the tensor
% 'scale' - the scale of the tensor
% 'line_width' - the width of the plot lines
%
% Returns the plot handle to the tensor
%
% See also: gtlib_plotGrowthTensorCross
%
% Dr. A. I. Hanna (2007)
error(nargchk(0,inf,nargin));
ungrowthfilename = [];
scale = 1;
if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error('%s %s %s', 'Arguments to', mfilename, 'must come param/value in pairs.')
end
offset = [0 0];
scale = 1;
linewidth = 1;
col = [1 1 0]; %[0 1 0]
axis_handle = [];
GT = [];
ellip_ph = [];
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'growth_tensor'
            GT = varargin{i+1};
        case 'offset'
            offset = varargin{i+1};
        case 'colour'
            col = varargin{i+1};
        case 'parent'
            axis_handle = varargin{i+1};
        case 'scale'
            scale = varargin{i+1};
        case 'linewidth'
            linewidth = varargin{i+1};
        otherwise
            error('%s\n%s %s', 'Unknown parameter name passed to show_region_areal_growth.', 'Name was', varargin{i});
    end
end

if isempty(GT)
    error('%s %s %s', 'Error ==>', mfilename, 'must have a growth tensor');
end
if isempty(axis_handle)
    axis_handle = gca;
end

hold(axis_handle, 'on');
theta = linspace(0, 2*pi, 50);
X = [scale*cos(theta(:)), scale*sin(theta(:)), zeros(length(theta),1)];
Y = GT*X';
Y(1,:) = Y(1,:) + offset(1);
Y(2,:) = Y(2,:) + offset(2);

ellip_ph = plot(axis_handle, Y(1, :), Y(2,:), 'Color', col, 'HitTest', 'off', 'LineWidth', linewidth);
cross_ph = gtlib_plotGrowthTensorCross('growth_tensor', GT, 'offset', offset, 'colour', col, 'parent', axis_handle, 'scale', scale, 'linewidth', linewidth);
%cross_ph = [];
varargout{1} = [ellip_ph, cross_ph];
varargout{2} = Y;
return;