function [major, minor, theta] = gtlib_growthTensor2Params(GT)
% function [major, minor, theta] = gtlib_growthTensor2Params(GT)
%
% A method that takes a growth tensor T and returns the direction of
% principle growth together with the growth rate along that direction and
% the growth rate perpendicular to that direction.
%
% Example
% Calculate the growth tensor
%GT = gtlib_growthParams2Tensor(2, 4, (3*pi)/9);
%
% For rigour we perform the reverse process
%[major, minor, theta] = gtlib_growthTensor2Params(GT)
%
% To visualize the growth tensor we make the unit circle
%theta = linspace(0, 2*pi, 200);
%X = [cos(theta); sin(theta); zeros(size(theta))];
% And apply the growth tensor to the data
%D = GT*X;
%%%%%%%%%%%%%%%%%%%%%
%
% The Art Corner
%
%%%%%%%%%%%%%%%%%%%%%
%figure(1); clf; hold on;
%plot3(X(1,:), X(2,:), X(3,:), 'b', 'LineWidth', 2);
%plot3(D(1,:), D(2,:), D(3,:), 'r', 'LineWidth', 2);
%V = D-X;
%N = size(X,2);
%m = 50;
%ind = 1:N/m:N;
%quiver3(X(1,ind), X(2,ind), X(3,ind), V(1,ind), V(2,ind), V(3,ind),0);
%grid on;
%view(2);
%axis image;
%xlabel('X'); ylabel('Y')
%title('Example of an Anisotropic Growth Tensor')
%
% Dr. A. I. Hanna (2007)
if nargin ~=1
    error('Usage: [major, minor, theta] = growthTensor2Params(GT)');
else
    if (any(size(GT) == [3 3])== 0)
        error('Input argument must be a 3x3 growth tensor');
    end
end
% recall GT = U*L*V' (but remember that U = V so actually we have U*L*U')
if any(isnan(GT(:))) || any(isinf(GT(:))) 
    fprintf(' - found NaN or Inf in growth tensor, returning default values\n');
    major = 1;
    minor = 1;
    theta = 0;
    return;
end
[U, L, V] = svd(GT);
%[L, ind] = sort(diag(L), 'descend');
L = diag(L);
%U = U(:,ind);
%V = V(:,ind);
major = L(1);
minor = L(2);
if U(1,1)==0
    theta = pi/2;
else
    theta = atan(U(2,1)/U(1,1));
end
return