function varargout = femlib_plotWedge(varargin)
% function varargout = femlib_plotWedge(varargin)
%
% Inputs:
% 'pts' - a matrix of x, y, z, data points
% 'edgecolor' - the color of the wedge edges
% 'axish' - the specified axis handle (default = gca).
%
% A drawing routine for displaying wedge shaped finite elements. The matrix
% associated with the parameter 'pts' must but in a certain order. we have
% the upper triangle points specified then the lower triangle points. See
% the example below.
%
% Example:
% X = [1 0 1;
%     0 1 1;
%     0 0 1;
%     1 0 -1;
%     0 1 -1;
%     0 0 -1];
%
% femlib_plotWedge('PTS', X, 'edgecolor', 'g');
%
% Dr. A. I. Hanna (2006)
error(nargchk(0,inf,nargin));
if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error(['Arguments to ', mfilename, ' must come param/value in pairs.']);
end
X = [];
axish = [];
temp = [];
edgecolor = [0 0 0];
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'pts'
            X = varargin{i+1};
        case 'axish'
            axish = varargin{i+1};
        case 'edgecolor'
            edgecolor = varargin{i+1};
        case 'temperature'
            temp = varargin{i+1};
        case 'facecolour'
            facecolour = varargin{i+1};

        otherwise
            error(['Unknown parameter name passed to femlib_plotWedge.  Name was ' varargin{i}])
    end
end
if isempty(X)
    error('pts parameter is required.')
end
if isempty(axish)
    axish = gca;
end
if isempty(temp)
    temp = ones(6, 1);
end
hold(axish, 'on');
ph = [];
linwidth = 2;
linstyle = '-';
%linstyle = 'none';
%ph(end+1) = plot3(axish, [X([1:3,1],1)], [X([1:3,1],2)], [X([1:3,1],3)], '-', 'Color', edgecolor, 'LineWidth', linwidth);
%ph(end+1) = plot3(axish, [X([4:6,4],1)], [X([4:6,4],2)], [X([4:6,4],3)], '-', 'Color', edgecolor, 'LineWidth', linwidth);
%ph(end+1) = plot3(axish, [X(1,1), X(4,1)],[X(1,2), X(4,2)],[X(1,3), X(4,3)], '-', 'Color', edgecolor, 'LineWidth', linwidth);
%ph(end+1) = plot3(axish, [X(2,1), X(5,1)],[X(2,2), X(5,2)],[X(2,3), X(5,3)], '-', 'Color', edgecolor, 'LineWidth', linwidth);
%ph(end+1) = plot3(axish, [X(3,1), X(6,1)],[X(3,2), X(6,2)],[X(3,3), X(6,3)], '-', 'Color', edgecolor, 'LineWidth', linwidth);
ph(end+1) = fill3(X(1:3, 1), X(1:3, 2), X(1:3, 3), temp(1:3), 'Parent', axish,'LineStyle', linstyle, 'EdgeColor', edgecolor);
ph(end+1) = fill3(X(4:6, 1), X(4:6, 2), X(4:6, 3), temp(4:6), 'Parent', axish,'LineStyle', linstyle, 'EdgeColor', edgecolor);
ph(end+1) = fill3([X(1,1), X(4,1) X(5,1), X(2,1)],[X(1,2), X(4,2) X(5,2), X(2,2)],[X(1,3), X(4,3) X(5,3), X(2,3)], temp([1 4 5 2]), 'Parent', axish,'LineStyle', linstyle, 'EdgeColor', edgecolor);
ph(end+1) = fill3([X(1,1), X(4,1) X(6,1), X(3,1)],[X(1,2), X(4,2) X(6,2), X(3,2)],[X(1,3), X(4,3) X(6,3), X(3,3)], temp([1 4 6 3]), 'Parent', axish,'LineStyle', linstyle, 'EdgeColor', edgecolor);
ph(end+1) = fill3([X(2,1), X(5,1) X(6,1), X(3,1)],[X(2,2), X(5,2) X(6,2), X(3,2)],[X(2,3), X(5,3) X(6,3), X(3,3)], temp([2 5 6 3]), 'Parent', axish,'LineStyle', linstyle, 'EdgeColor', edgecolor);
set(ph, 'facecolor', facecolour, 'FaceAlpha', 0.6);
varargout{1} = ph;
hold(axish, 'off');
return;