function varargout = femlib_plotMesh(varargin)

% function ph = femlib_plotMesh(X, element, dorsalDivide)
%
% Inputs:
%  X - a Nx2 matrix of global vertices
%  element - an array of structures of elements
%  dorsalDivide - the index that seperates the dorsal from the ventral
%
% Outputs:
%  ph - the cell array of plot handles
%
% Dr. A. I. Hanna (2006).
error(nargchk(0,inf,nargin));
if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error(['Arguments to ', mfilename, ' must come param/value in pairs.']);
end
X = [];
axish = [];
edgecolor = 'k';
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'pts'
            X = varargin{i+1};
        case 'mesh'
            mesh = varargin{i+1};
        case 'axish'
            axish = varargin{i+1};
        case 'edgecolor'
            edgecolor = varargin{i+1};
        otherwise
            error(['Unknown parameter name passed to femlib_plotMesh.  Name was ' varargin{i}])
    end
end
if isempty(mesh)
    error('mesh parameter is required.')
end
if isempty(axish)
    axish = gca;
end
X = mesh.X;
axes(axish);
element = mesh.element;
dorsalDivide = mesh.dorsalDivide;
ph = {};
hold(axish, 'on');
for i=1:length(element)
    ind = element(i).ind;
    Xe = X([ind, ind+dorsalDivide],:);
    x = Xe(1:3, :);
    temp = mesh.vertex_temp([ind, ind+dorsalDivide]);
    ph{i} = femlib_plotWedge('PTS', Xe, 'faceColour', element(i).colour, 'edgecolor', edgecolor, 'temperature', temp, 'axish', axish);
end
hold(axish, 'off');
colormap(axish, 'winter');
varargout{1} = ph;