function [rpts, ind] = femlib_orderVertices(pts)
% function [rpts] = femlib_orderVertices(pts)
%
% Orders the vertices given in pts in a clockwise order.
%
% Dr. A. I. Hanna (2006).
if size(pts,1)>1
    mpts = mean(pts,1);
else
    mpts = pts;
end
rpts = double(pts) - ones(size(pts,1),1)*mpts;
[theta, r] = cart2pol(rpts(:,1), rpts(:,2));
polvec = [theta, r];
[polvec, ind] = sortrows(polvec,1);
[rpts(:,1), rpts(:,2)] = pol2cart(polvec(:,1), polvec(:,2));
rpts = rpts + ones(size(rpts,1),1)*mpts;
return;