function element = femlib_getElements(pts, T)
% function element = femlib_getElements(pts)
%
% Here we need to do a few things, firstly we need to get the
% triangulation, and then we need to make sure that all the triangles are
% ordered clockwise. Then we are set.
%
% Dr. A. I. Hanna (2006).
if nargin<2
    T = delaunay(pts(:,1), pts(:,2));
end
T = femlib_fixTriMesh(T, pts);
for i=1:size(T, 1)
    element(i).ind = T(i,:);
    element(i).preStrain = femlib_getPreStrain;
    element(i).residualStrain = zeros(6, 1);
    col = [0    0.5020    0.2510] + rand(1, 3)/10;
    col(col>1) = 1;
    element(i).colour = col;
end
return;