function meshInfo = femlib_createBasicMesh(pts, T)
% function mesh = femlib_createBasicMesh(pts, T)
%
% Generates a default mesh structure
%
% Dr. A. I. Hanna (2006)
dorsalVertices = [pts, ones(size(pts,1),1)];
ventralVertices = [pts, -1*ones(size(pts,1),1)];
X = [dorsalVertices; ventralVertices];
% Set up the general mesh info.
meshInfo.dorsalDivide = size(pts, 1);
meshInfo.nodes = size(X,1);
meshInfo.vertex_temp = 1*ones(size(X,1),1);
meshInfo.element = femlib_getElements(pts, T);
fprintf('%d number of elements in mesh\n', length(meshInfo.element));
meshInfo.fixedEquations = femlib_getFixedEquations(meshInfo.dorsalDivide);
meshInfo.dof = 3;
meshInfo.maxelarea = 20;
meshInfo.scalingMatrix = 1;
meshInfo.D = femlib_getMaterialStiffnessMatrix(3000, 0.35);
meshInfo.X = X;
meshInfo.pts = pts;
[meshInfo.GQP, meshInfo.wGauss] = femlib_GQPwedge;
