%Hanna, 2005
function [value] = UngrowingTool(varargin)
if checkSATDir(pwd) == 0
    fprintf('You are not in a valid SectorAnalysisToolbox Project directory\n');
    return;
end
ad.curr_grid = [];
ad.curr_grid_filename = '';
error(nargchk(0,inf,nargin));
% Open, move, and get the handles from the figure file.
fig = openfig(mfilename, 'reuse');
movegui(fig, 'center');
set(fig, 'Visible', 'on');
handles = guihandles(fig);
set(fig, 'Color', get(handles.uipanel10, 'BackgroundColor'));

xlabel(handles.error_axis, 'number of iterations (k)', 'FontSize', 6);
ylabel(handles.error_axis, '10log_{10}(error^2(k))', 'FontSize', 6);
set(handles.error_axis, 'FontSize', 6);
set(handles.imageAxis, 'FontSize', 6);

% Set all the callback functions
%set(handles.select_stage_btn, 'callback', {@doSelectStages});
%set(handles.list_help_btn, 'callback', {@doListHelp});
%set(handles.flip_btn, 'callback', {@doFlip});
%set(handles.calc_growth_param_btn, 'callback', {@doCalcGrowthParam});
set(handles.edithours_menu, 'callback', {@doEditTimeBetweenStages});
set(handles.save_menu, 'callback', {@doSaveParams});
set(handles.load_menu, 'callback', {@doOpenGrid});
set(handles.ungrow_btn, 'callback', {@doUngrow});
set(handles.quit_menu, 'callback', {@doQuit});
set(handles.show_ellipsoids_menu, 'callback', {@doShowEllipsoids}); 
set(handles.show_gr_anis_menu, 'callback', {@doShowGrowthAnis});
set(handles.show_stage_image_btn, 'callback', {@doShowStageImage});
set(handles.export_to_fem_menu, 'callback', {@doExportToFEM});
set(handles.export_to_canvas_menu, 'callback', {@doExportToCanvas});

set(handles.fem_growth_menu, 'callback', {@doStartFEMGrowth});

% Initialize the application data structure
ad.figMain = fig;
ad.StagedDirString = 'Staged';
ad.OriginalsDirString = 'Originals';
ad.ProcessedDirString = 'Processed';
ad.DataDir = [ad.StagedDirString, filesep, 'Data'];
ad.GridDir = [ad.DataDir, filesep, 'Grids'];
ad.UngrowingDataDir = [ad.DataDir, filesep, 'UngrowthData'];
ad.FEMGrowthDataDir = [ad.DataDir, filesep, 'FEMGrowthData'];

if ~exist(ad.UngrowingDataDir, 'dir') 
    mkdir(ad.UngrowingDataDir); 
end
ad.MeanShapeName = [ad.DataDir, filesep, 'mean_shape.mat'];
ad.projectpath = pwd;
ad.value = 0;
ad.handles = handles;
ad.grid = [];
ad.UngrowthData = [];

customtoolbar(ad.figMain);
setappdata(0,'UngrowingTool',ad);
try
    uiwait(fig);
catch
    if ishandle(fig)
        delete(fig)
    end
end
value = 0;
return;
%%%
%
%%%
function doQuit(quit, evd)
ad = getappdata(0,'UngrowingTool');
delete(ad.figMain);
return
%%%%%%
%
%%%%%%
function doListHelp(list_help_btn, evd) %#ok<INUSD,INUSD>
ad = getappdata(0,'UngrowingTool');
Data=1:64;
Data=(Data'*Data)/64;
[str, error] = sprintf('%s\n%s', 'The ordering of this list is important.','The first stage in the list refers to the set of images that were induced last (i.e. small sectors)');
h=msgbox(str,'Ordered List Help','custom',Data,hot(64), 'modal');

%%%%%%
%
%%%%%%
function doCalcGrowthParam(calc_growth_param_btn, evd) %#ok<INUSD,INUSD>
ad =getappdata(0, 'UngrowingTool');
if isempty(ad.curr_grid)
	uiwait(msgbox('You must open a grid first.','Help','modal'));
    return;
end
stages = get(ad.handles.stage_list_box, 'String');
cla(ad.handles.imageAxis);
organ_grid = ad.curr_grid.base_grid;
plot_springs(organ_grid, ad.handles.imageAxis);
axis(ad.handles.imageAxis, 'image', 'ij');

%[average_info, ordering] = get_stage_grid_info(stages, organ_grid);

%if isempty(average_info)
%    return;
%end
%if length(average_info)==1
%     uiwait(msgbox('You must have at least 2 stages to calculate any growth.','Not enough stages selected.','modal'));    
%    return;
%end
%smooth = get(ad.handles.smooth_chk, 'Value');
%N = logical(g.region_info.region_adj_mat);
%[ungrowth_tensors] = calculate_growth_params_from_gt(average_info);
%[ungrowth_tensors] = check_principal_directions(ungrowth_tensors);
%ungrowth_tensors = organ_grid.ungrowth_tensors;
%if smooth
%    [ungrowth_tensors] = smooth_growth_parameters(ungrowth_tensors, N);
%end
for i=1:length(ad.curr_grid.stage_grids)
   if ~isfield( ad.curr_grid.stage_grids{i}, 'deltaSt')
       ad.curr_grid.stage_grids{i}.deltaSt = 20;
   end
end

stage_grids = ad.curr_grid.stage_grids;

growth_names = build_stage_growth_names(stage_grids);
[growth_display_string] = build_growth_param_string(stage_grids, growth_names);
[a, grid_name] = fileparts(ad.curr_grid_filename);
set(ad.handles.grid_name_txt, 'String', grid_name);
set(ad.handles.growth_param_list, 'String', growth_display_string);
%ad.ungrowth_params.ungrowth_tensors = ungrowth_tensors;
ad.ungrowth_params.stages = stages;
%ad.ungrowth_params.ordering = ordering;
ad.ungrowth_params.growth_names = growth_names;
ad.ungrowth_params.grid_name = grid_name;
%ad.curr_grid.ungrow_grid = organ_grid;
%ad.ungrowth_params.N = N;
ad.ungrowth_params.stage_delta_t = str2double(get(ad.handles.stage_time_txt, 'String'));
setappdata(0, 'UngrowingTool', ad);
%%%%%%
%
%
%%%%%%
function [growth_display_string] = build_growth_param_string(stage_grids, growth_names)

number_of_stages = length(stage_grids);
growth_display_string = {};
for i=1:number_of_stages
    ug_tensors = stage_grids{i}.ungrowth_tensors;
    if ~isfield(stage_grids{i}, 'deltaSt')
        stage_grids{i}.deltaSt = 20;
    end
    number_of_regions = size(ug_tensors,3);
    for ii=1:number_of_regions
        [smax, smin, theta] = gtlib_growthTensor2Params(ug_tensors(:,:,ii));
        [str, err] = sprintf('%s   Region: %2.2d   s_max: %2.4f    s_min: %2.4f    theta: %2.4f', growth_names{i}, ii, smax, smin, theta);
        growth_display_string = cat(1, growth_display_string, str);
    end
end
%%%%%%
%
%
%%%%%%
% This function really is just to produce a set of names, so if we have
% stages S1, S2, S3,.. we want a set of names such as S1_S2, S2_S3 etc...
function [growth_names] = build_stage_growth_names(stage_grids)
num_stages = length(stage_grids);
growth_names = cell(num_stages,1);
for i=1:num_stages    
   growth_names{i} = [stage_grids{i}.stage_info.prev, '_', stage_grids{i}.stage_info.post]; 
end
%%%%%%
%
%
%%%%%%
function [grid_name, grid_path] = select_grid()
ad =getappdata(0, 'UngrowingTool');
[grid_name, grid_path] = uigetfile('*.mat', 'Pick an Grid-file', [ad.GridDir, filesep]);
if isequal(grid_name,0) || isequal(grid_path,0)
    grid_name = [];
    grid_path = [];
end
ad.grid.name = grid_name;
ad.grid.path = grid_path;
setappdata(0, 'UngrowingTool', ad);
return;
%%%%%%
%
%
%%%%%%
function doSaveParams(save_btn, evd) %#ok<INUSD,INUSD>
ad =getappdata(0, 'UngrowingTool');
[filename, pathname] = uiputfile('*.mat', 'Save As', [ad.UngrowingDataDir, filesep, 'Untitled.mat']);
if isequal(filename,0) || isequal(pathname,0)
    disp('User pressed cancel')
else
    %ungrowth_params = ad.ungrowth_params;
    stage_delta_t = ad.ungrowth_params.stage_delta_t;
    ungrown_grids = ad.ungrown_grids;
    grid_name = get(ad.handles.grid_name_txt,'String');
    save(fullfile(pathname, filename), 'ungrown_grids', 'grid_name', 'stage_delta_t');
    disp(['User selected ', fullfile(pathname, filename)]);
    uiwait(msgbox('Finished saving your ungrowth data.','Save Done','modal'));
end
setappdata(0, 'UngrowingTool', ad);
%%%%%%
%
%
%%%%%%
function doLoadParams(load_btn, evd) %#ok<INUSD,INUSD>
ad =getappdata(0, 'UngrowingTool');
[filename, pathname] = uigetfile('*.mat', 'Save As', [ad.UngrowingDataDir, filesep, 'Untitled.mat']);
if isequal(filename,0) || isequal(pathname,0)
    disp('User pressed cancel')
else
    growth_parameters = load(fullfile(pathname, filename));
    ad.growth_params = growth_parameters.growth_parameters;
    [growth_display_string] = build_growth_param_string(ad.growth_params.scaling_factors, ad.growth_params.growth_params, ad.growth_params.growth_names);
    set(ad.handles.grid_name_txt, 'String', ad.growth_params.grid_name);
    set(ad.handles.growth_param_list, 'String', growth_display_string);
    disp(['Loading growth parameters ', filename])
    R = load([ad.GridDir , filesep, ad.growth_params.grid_name]);
    cla(ad.handles.imageAxis);
    display_springs(R.region_info.Springs.S, ad.handles.imageAxis);
    axis(ad.handles.imageAxis, 'image', 'xy');
end
setappdata(0, 'UngrowingTool', ad);
%%
function doEditTimeBetweenStages(hoursmenu, evd)
ad =getappdata(0, 'UngrowingTool');
if isempty(ad.curr_grid)
	uiwait(msgbox('You must open a grid first.','Help','modal'));
    return;
end

setappdata(0, 'UngrowingTool', ad);
%%%
%
%%%
function doUngrow(ungrow_btn, evd) %#ok<INUSD,INUSD>
ad =getappdata(0, 'UngrowingTool');
if isempty(ad.curr_grid)
	uiwait(msgbox('You must open a grid first.','Help','modal'));
    return;
end
set(ad.figMain, 'Pointer', 'watch', 'DoubleBuffer', 'on');
if ~isfield(ad, 'ungrowth_params')
	uiwait(msgbox('Could not find any ungrowth data, please try again.','No Ungrowth Data','modal'));
    return;
end
if isempty(ad.ungrowth_params.grid_name)
    return;
end
curr_grid = ad.curr_grid;
cla(ad.handles.imageAxis);
plot_grid(curr_grid.base_grid, ad.handles.imageAxis);
plot_shape(curr_grid.base_grid, ad.handles.imageAxis);
axis(ad.handles.imageAxis, 'image', 'ij');
xlim = get(ad.handles.imageAxis, 'XLim');
ylim = get(ad.handles.imageAxis, 'YLim');
set(ad.handles.imageAxis, 'XLim', [xlim(1)-50 xlim(2)+50], 'YLim', [ylim(1)-50 ylim(2)+50]);
extern_iter = str2double(get(ad.handles.external_iter_number, 'String'));
spr_const = str2double(get(ad.handles.external_spring_constant, 'String'));
lambda = abs(str2double(get(ad.handles.lambdastr, 'String')));
dampconst = abs(str2double(get(ad.handles.dampstr, 'String')));
dtconst = abs(str2double(get(ad.handles.dtstr, 'String')));
tolconst = abs(str2double(get(ad.handles.tolstr, 'String')));
deltaSt = abs(str2double(get(ad.handles.stage_time_txt, 'String')));
ad.ungrowth_params.stage_delta_t = deltaSt;
[ungrown_grids] = satlib_ungrow('Curr_Grid', curr_grid, 'maxiter', extern_iter, 'K', spr_const, ...
    'plot_data', ad.handles, 'lambda', lambda, 'damp', dampconst, 'dt', dtconst, 'tol', tolconst);

%[ungrown_grids] = ungrow_aih(curr_grid, extern_iter, spr_const, ad.handles, lambda, dampconst, dtconst, tolconst);

final_grid = ungrown_grids{end};
cla(ad.handles.imageAxis);
%plot_springs(final_grid, ad.handles.imageAxis);
plot_grid(final_grid, ad.handles.imageAxis);
%plot_shape(final_grid, ad.handles.imageAxis);
axis(ad.handles.imageAxis, 'image', 'ij');
grid(ad.handles.imageAxis, 'on');
%ad.ungrowth_params = ungrowth_params;
ad.ungrown_grids = ungrown_grids;
set(ad.figMain, 'Pointer', 'arrow');
setappdata(0, 'UngrowingTool', ad);
return;
%%%%%%
%
%
%%%%%%
function doShowEllipsoids(show_ellipsoids_btn, evd) %#ok<INUSD,INUSD>
ad = getappdata(0, 'UngrowingTool');
grid_name = get(ad.handles.grid_name_txt,'String');
if exist([ad.GridDir, filesep, grid_name], 'file')
    show_average_ellipses_all_stages(ad.DataDir, ad.GridDir, grid_name);
else
    show_average_ellipses_all_stages(ad.DataDir);
end
setappdata(0, 'UngrowingTool', ad);
%%%%%%
%
%
%%%%%%
function doFlip(flip_btn, evd) %#ok<INUSD,INUSD>
ad =getappdata(0, 'UngrowingTool');
tostr = get(ad.handles.stage_list_box, 'String');
toval = get(ad.handles.stage_list_box, 'Value');
if isempty(tostr)
    return;
end
tostr = tostr(:);
tostr = flipud(tostr);
set(ad.handles.stage_list_box, 'String', tostr);
setappdata(0, 'UngrowingTool', ad);
%%%%%%
%
%
%%%%%%
function doSelectStages(select_stage_btn, evd) %#ok<INUSD,INUSD>
ad = getappdata(0,'UngrowingTool');
if isempty(ad.curr_grid)
	uiwait(msgbox('You must open a grid first.','Help','modal'));
    return;
end
stages = getGridStages(ad.curr_grid);
[ordered_stages, value] = SelectOrderListDlg('liststring', stages);
set(ad.figMain, 'Visible', 'on');
if value
    set(ad.handles.stage_list_box, 'String', ordered_stages);
end
%%%
%
%%%
function doOpenGrid(open_btn, evd) %#ok<INUSD,INUSD>
ad = getappdata(0,'UngrowingTool');
[grid_name, grid_path] = select_grid;
if isempty(grid_name)
    return;
end
ad.curr_grid = load([grid_path, filesep, grid_name]);
ad.curr_grid_filename = [grid_path, filesep, grid_name];
fprintf(' - opened grid %s\n', grid_name');
stages = getGridStages(ad.curr_grid);
set(ad.handles.stage_list_box, 'String', stages);
setappdata(0,'UngrowingTool', ad);
doCalcGrowthParam;
%%%
%
%%%
function stages = getGridStages(curr_grid)
stages = curr_grid.base_grid.stage_info.stages;
return;
%num_levels = length(curr_grid.ungrow_grid.stage_info.stages);
%stages = cell(num_levels, 1);
%for i=1:num_levels
%    stage = av_info{i}.stage;
%    [a, stage] = fileparts(stage);
%    stages{i} = stage;
%end
%return

%%%
%
%%%
function customtoolbar(figh)
hA = findall(figh);
openfileh=findobj(hA,'TooltipString','Open File');
set(openfileh, 'ClickedCallback', {@doOpenGrid});
set(openfileh, 'TooltipString', 'Open Grid');

saveh=findobj(hA,'TooltipString','Save Figure');
set(saveh, 'ClickedCallback', {@doSaveParams});
set(saveh, 'TooltipString', 'Save Grid');
roth=findobj(hA,'TooltipString','Rotate 3D');
datah=findobj(hA,'TooltipString','Data Cursor');
colbarh=findobj(hA,'TooltipString','Insert Colorbar');
legh=findobj(hA,'TooltipString','Insert Legend');
hideh=findobj(hA,'TooltipString','Hide Plot Tools');
showh=findobj(hA,'TooltipString','Show Plot Tools and Dock Figure');
newh=findobj(hA,'TooltipString','New Figure');

delete([newh, roth, datah, colbarh, legh, hideh, showh]); 
return;
%%%
%
%%%
function doShowGrowthAnis(showmenu, evd)
ad =getappdata(0, 'UngrowingTool');
[filename, pathname] = uigetfile('*.mat', 'Pick an Ungrowth File', [ad.UngrowingDataDir, filesep]);
if isequal(filename,0) || isequal(pathname,0)
    disp('User pressed cancel')
    return;
end
ungrowthfilename = [pathname, filesep, filename];
show_region_areal_growth('ungrowthfilename',ungrowthfilename) ;
return
%%%
%
%%%
function doShowStageImage(show_btn, evd)
ad =getappdata(0, 'UngrowingTool');
files = dir(ad.StagedDirString);
files = cleanup_stage_list({files.name});
[s,v] = listdlg('PromptString','Select a file:', 'SelectionMode','single', 'ListString', files);
if isempty(s)
    return;
end
stage_dir = [pwd, filesep, ad.StagedDirString, filesep, files{s}];
files = dir(stage_dir);
files = {files.name};
for i=1:length(files)
    imagefilename = [stage_dir, filesep, files{i}, filesep, files{i},'.jpg'];
    if exist(imagefilename, 'file')
        im = imread(imagefilename);
        [a, imagefilename] = fileparts(imagefilename);
        figure;
        imshow(im);
        title(imagefilename);
        break;
    end
end
return;
%%

function doExportToCanvas(exportmenu, evd)
ExportGrowthData2Canvas;
return
%%%
%
%%%
function doExportToFEM(exportmenu, evd)
Export2FEMGrowthTool;
return
%%%
%
%%%
function doStartFEMGrowth(fem_growth_btn, evd)
ad =getappdata(0, 'UngrowingTool');
FEMGrowthTool('growth_directory', ad.FEMGrowthDataDir);
return;


%%%%
%
%
%%%%
function calcAverageInfo()

area_thr = 20;

if ~isfield(ad.regions, 'stage_info')
    uiwait(msgbox('You must select some stages to process first.','No Stages','modal'));
    return

end
if isempty(ad.regions.stage_info)
    uiwait(msgbox('You must select some stages to process first.','No Stages','modal'));
    return
end
FILES = ad.regions.stage_info.stages;
StagedDirString = ad.regions.stage_info.staged_dir;
fprintf('Calculating sector info for stages:\n');
for i=1:length(FILES)
    fprintf('%s\n', [StagedDirString, filesep, FILES{i}]);
end
av_info = cell(length(FILES), 1);
waitbar_h = waitbar(0, 'Calculating region statistics, please wait...');

grid = ad.regions;
T = grid.tri_info.T;
tri_pts = grid.tri_info.pts;


for i=1:length(FILES)
    stage = [StagedDirString, filesep, FILES{i}];
    [region_info, areas] = calc_stage_sector_info_for_trimesh(stage, T, tri_pts, grid.stage_tri_ind{i}, area_thr);
    %[region_info, areas] = calc_stage_sector_info(stage, R, centroids, area_thr);
    
    [av_info{i}.average_stage_sector_info] = calc_average_stage_sector_info(region_info);
    av_info{i}.stage = stage;
    av_info{i}.mean_area = mean(areas);
    %av_info{i}.median_area = median(areas);
    %av_info{i}.mode_area = mode(areas);
    waitbar(i/length(FILES), waitbar_h);
end
close(waitbar_h);
ad.av_info = av_info;
%ad.sector_region_info = sector_region_info;
setappdata(0, 'GridEditorToolData', ad);