%Hanna, 2005
function [value] = StatViewerTool(varargin)
if checkSATDir(pwd) == 0
    fprintf('You are not in a valid SectorAnalysisToolbox Project directory\n');
    return;
end
error(nargchk(0,inf,nargin));
% Open, move, and get the handles from the figure file.
fig = openfig(mfilename, 'reuse');
movegui(fig, 'center');
set(fig, 'Visible', 'on');
handles = guihandles(fig);
set(fig, 'Color', get(handles.text1, 'BackgroundColor'));

% Set all the callback functions
set(handles.show_all_stages_btn, 'callback', {@doShowAllStages});
set(handles.show_stage_sector_info_btn, 'callback', {@doShowStageSectorInfo});
set(handles.show_mean_sector_area_btn, 'callback', {@doShowMeanSectorArea});
set(handles.show_av_ellipse_stage_btn, 'callback', {@doShowAvEllipseForStage});
set(handles.show_all_ellipse_stage_btn, 'callback', {@doShowAllEllipseForStage});
set(handles.average_growth_rate_btn, 'callback', {@doShowAverageGrowthRate});
set(handles.av_sector_number, 'callback', {@doShowAverageNumberOfSectors});
set(handles.showgrthanisobtn, 'callback', {@doShowGrowthAndAnisotropy});
set(handles.prop_sec2organ, 'callback', {@doShowProportionSectorToOrgan});
set(handles.showwarpedsectors_btn, 'callback', {@doShowAllWarpedSectors});
set(handles.warpedellipses_btn, 'callback', {@doShowAllWarpedEllipses});
set(handles.sectorarea_btn, 'callback', {@doSaveSectorAreaToExcel});

% Initialize the application data structure
ad.figMain = fig;
ad.StagedDirString = 'Staged';
ad.OriginalsDirString = 'Originals';
ad.ProcessedDirString = 'Processed';
ad.DataDir = [ad.StagedDirString, filesep, 'Data'];
ad.UngrowthDir = [ad.DataDir, filesep, 'UngrowthData'];
ad.MeanShapeName = [ad.DataDir, filesep, 'mean_shape.mat'];
ad.projectpath = pwd;
ad.value = 0;
ad.handles = handles;
setappdata(0,'StatViewerTool',ad);

try
    uiwait(fig);
catch
    if ishandle(fig)
        delete(fig)
    end
end
value = 0;
return;
%%%
%
%%%
function doShowAvEllipseForStage(show_all_stages_btn, evd)
ad = getappdata(0,'StatViewerTool');
set(ad.figMain, 'Pointer', 'watch');
show_average_ellipses_for_stage(get(ad.handles.mean_shape_dir_txt, 'String'));
set(ad.figMain, 'Pointer', 'arrow');
%%%
%
%%%
% function doShowRegionsonGrid(show_all_regions, evd)
% ad = getappdata(0,'StatViewerTool');
% set(ad.figMain, 'Pointer', 'watch');
% show_grid_regions(get(ad.handles.mean_shape_dir_txt, 'String'));
% set(ad.figMain, 'Pointer', 'arrow');
%%%
%
%%%
function doShowAllEllipseForStage(show_all_stages_btn, evd)
ad = getappdata(0,'StatViewerTool');
set(ad.figMain, 'Pointer', 'watch');
show_average_ellipses_all_stages(get(ad.handles.mean_shape_dir_txt, 'String'));
set(ad.figMain, 'Pointer', 'arrow');
%%%
%
%%%
function doShowAverageNumberOfSectors(average_sector_number_btn, evd)
ad = getappdata(0,'StatViewerTool');
set(ad.figMain, 'Pointer', 'watch');
show_average_number_of_sectors(get(ad.handles.mean_shape_dir_txt, 'String'));
set(ad.figMain, 'Pointer', 'arrow');
%%
%
function doShowAllWarpedSectors(btn, evd)
ShowWarpedSectors;
%%%
function doShowAllWarpedEllipses(btn, evd)
ShowWarpedEllipses;

%
%%%
function doShowProportionSectorToOrgan(prop, evd)
figure;
satdisp_sector_coverage;
%%%
%
%%%
function doShowGrowthAndAnisotropy(showbtn, evd)
ad = getappdata(0,'StatViewerTool');
set(ad.figMain, 'Visible', 'off');
SATPlotOptionsTool;
set(ad.figMain, 'Visible', 'on');
return
%%%
%
%%%
function doShowAverageGrowthRate(average_growth_rate_btn, evd)
ad = getappdata(0,'StatViewerTool');
set(ad.figMain, 'Pointer', 'watch');
show_average_stage_growth_rate(get(ad.handles.mean_shape_dir_txt, 'String'));
set(ad.figMain, 'Pointer', 'arrow');
%%%
%
%%%
function doShowMeanSectorArea(show_all_stages_btn, evd)
ad = getappdata(0,'StatViewerTool');
set(ad.figMain, 'Pointer', 'watch');
show_mean_sector_area;
set(ad.figMain, 'Pointer', 'arrow');
%%%
%
%%%
function doShowStageSectorInfo(show_all_stages_btn, evd)
ad = getappdata(0,'StatViewerTool');
set(ad.figMain, 'Pointer', 'watch');
show_stage_sector_info(get(ad.handles.mean_shape_dir_txt, 'String'));
set(ad.figMain, 'Pointer', 'arrow');
%%%
%
%%%
function doShowAllStages(show_all_stages_btn, evd)
ad = getappdata(0,'StatViewerTool');
set(ad.figMain, 'Pointer', 'watch');
show_all_stages(get(ad.handles.mean_shape_dir_txt, 'String'));
set(ad.figMain, 'Pointer', 'arrow');


function doSaveSectorAreaToExcel(sectorarea_btn, evd)
SaveSectorAreaToExcel;

