function [w, orig, im, binim, snew] = GFP_confocal_MSE(im, w, binim)

%do some image normalise - (don't really need to do this tho)
im = double(im);
im = im./max(im(:));
im = uint8(im.*255);
im = double(im);
im = im./max(im(:));
orig = im;
im = imadjust(im, stretchlim(im));

%generate organ background image
if nargin<3
    binim = calc_binim(im);
end
if(sum(binim(:)) == 0)
    fprintf('Error with the binary image\n');
    orig = zeros(size(im));
    snew = zeros(size(im));
    return;
end
waitbar(1/50, w);

%maskout image
im2 = zeros(size(im));
for i=1:3
    im2(:,:,i) = binim .* im(:,:,i);
end

waitbar(20/50, w);

%find some intresting sectors
bw = im2(:,:,2)> .2; % .2 seems to be a nice estimate.

se90 = strel('line', 3, 90);
se0 = strel('line', 3, 0);

bw = imdilate(bw,[se90 se0]);
bw = imfill(bw,'holes');

seD = strel('diamond',1);
bw = imerode(bw,seD);
bw = imerode(bw,seD);

bw = bwareaopen(bw, 100);
bw4_perim = bwperim(bw);

snew = bw;
im = add_spots(orig, snew, [0 0 1]);

function [binim] = calc_binim(im)
binim = im(:,:,1)>.7;
binim = ~binim;
binim = bwareaopen(binim, 5000);
return;

function [im] = add_spots(im, spots, col)

if (nargin == 2)
    col = [1 0 0];
end
ind = find(spots == 1);
imr = im(:,:,1);
img = im(:,:,2);
imb = im(:,:,3);
imr(ind)=col(1);
img(ind)=col(2);
imb(ind)=col(3);
im(:,:,1) = imr;
im(:,:,2) = img;
im(:,:,3) = imb;