function warpedSectors = warpSectorsViaTrianglesConcave(newEdge, oldEdge, oldSectorBoundaries)
debug = 0;

triA = [1:size(oldEdge,1)]';
triB = [2:size(oldEdge,1) 1]';
triC = [ones(size(triA,1),size(triA,2)) * (size(oldEdge,1)+1)];
tri = [triA triB triC];

oldEdgeCenter = mean(oldEdge);
oldEdges = [oldEdge;oldEdgeCenter];
newEdgeCenter = mean(newEdge);
newEdges = [newEdge;newEdgeCenter];

if(debug)
figure(); hold on
triplot(tri,oldEdges(:,1),oldEdges(:,2))
end

%for each triangle calculate the warp transform
for i = 1:size(tri,1)
    for j = 1:3
        oldTriangle(j,:,i) = oldEdges(tri(i,j),:);
        newTriangle(j,:,i) = newEdges(tri(i,j),:);
    end
    Tinv{i} = cp2tform(oldTriangle(:,:,i), newTriangle(:,:,i), 'affine');
    
end

%for each boundary
for b=1:length(oldSectorBoundaries)
    %for each boundary pixel find the triangle it lies in
    s = oldSectorBoundaries{b};
    x =s(:,1); y = s(:,2);
    
%     figure(3); hold on;
%     plot(x,y,'rx')
%     plot(oldEdge(:,1),oldEdge(:,2),'ro');
    
    %for each triangle
    for i = 1:size(tri,1)
        %otX = [oldTriangle(:,1,i) ;oldTriangle(1,1,i)]
        %otY = [oldTriangle(:,2,i) ;oldTriangle(1,2,i)]
       [in on] = inpolygon(x,y,oldTriangle(:,1,i),oldTriangle(:,2,i));
       inTri(:,i) = or(in,on);
    end
    for j = 1:size(inTri,1)
        inTriIdxs(j,:) = max(find(inTri(j,:)==1));
    end
    
    for j = 1:size(inTri,1)
        [xm(j), ym(j)] = tformfwd(Tinv{inTriIdxs(j,:)}, x(j), y(j));
        
    end
    
     %figure(3); hold on
     %plot(xm,ym,'bx')
     %plot(newEdge(:,1),newEdge(:,2),'bo');
    
    warpedSectors{b} = [xm(:), ym(:)];
    
    %hurts me to have to so this...
    clear inTri xm ym
    %cla
    
end