function SectorAreaTool(varargin)
% function SectorAreaTool(varargin)
%
% Notes: every region must have at least 4 control points so we can find an
% inverse transform for the strain matrix.
% Hanna, 2007

if checkSATDir(pwd) == 0
    fprintf('You are not in a valid SectorAnalysisToolbox Project directory\n');
    return;
end
error(nargchk(0,inf,nargin));
% Open, move, and get the handles from the figure file.
fig = openfig(mfilename, 'reuse');
movegui(fig, 'center');
set(fig, 'Visible', 'on');
handles = guihandles(fig);
set(fig, 'Color', get(handles.uipanel10, 'BackgroundColor'));

% Set all the callback functions
set(handles.open_image_menu, 'callback', {@doOpenImage});


% Initialize the application data structure
ad.figMain = fig;
ad.data.im_path = [];
ad.data.im_filename = [];
ad.data.im = [];
ad.handles = handles;

setappdata(0,'SectorAreaToolData',ad);
try
    uiwait(fig);
catch
    if ishandle(fig)
        delete(fig)
    end
end
value = 0;
return;
%%%
%
%%%
function doOpenImage(open, evd)
ad =getappdata(0, 'SectorAreaToolData');

[filename, pathname] = uigetfile('*.m', 'Pick an M-file');
if isequal(filename,0) || isequal(pathname,0)
    disp('User pressed cancel')
end
ad.data.im_path = pathname;
ad.data.im_filename = filename;
ad.data.im = imread([pathname, filesep, filename]);
[a, filename] = fileparts(filename);

setappdata(0, 'SectorAreaToolData', ad);