function b = tri2boundary(tri, pts)

b = [];
N = size(tri,1);
for i=1:N
    t = tri(i,:);
    t = cat(2, t, t(1));
    for ii=1:3
        e = t(ii:ii+1);
        in = testedge(e, tri, pts);
        if in==0
            b = cat(1, b, e);
        end
    end
end
return;
%%
function in = testedge(e, tri, pts)
in = 1;

E = pts(e,:);
mu = mean(E);
v = E(1,:) - E(2,:);
p = [-v(2), v(1)];
p = p./norm(p);
p = p*norm(v)*0.01;
q = p + mu;
in1 = tsearch(pts(:,1), pts(:,2), tri, q(1), q(2));
q = -p + mu;
in2 = tsearch(pts(:,1), pts(:,2), tri, q(1), q(2));
in = ~any(isnan([in1, in2]));


return

