function average_sector_info = stage_info2average_region_info(stage_grid, stage_info)

T = stage_grid.tri_info.T;
tri_pts = stage_grid.tri_info.pts;

% figure(1); clf; hold on;
% triplot(T, tri_pts(:,1), tri_pts(:,2))
% axis image ij
% 
%  c = [stage_info.Centroid]';
%     c = reshape(c, 2, length(c)/2);
% plot(c(1,:), c(2,:), '.');


region_tri_ind = stage_grid.region_tri_ind;
num_regions = length(region_tri_ind);
RegionInfo = cell(1, num_regions);
for i=1:length(stage_info)
    sector = stage_info(i);

    tind = tsearch(tri_pts(:,1), tri_pts(:,2), T, sector.Centroid(1), sector.Centroid(2));
    if ~isnan(tind)
        region_num = findRegionContainingTri(region_tri_ind, tind);
        if region_num ~=-1
            RegionInfo{region_num} = cat(3, RegionInfo{region_num}, sector.growthTensor);
        end
    %else
    %    fprintf(' - centroid not in any triangle\n');
    end
end
average_sector_info = zeros(3,3,num_regions);
for i=1:num_regions
    if isempty(RegionInfo{i})
        average_sector_info(1,1,i) = 1 + realmin;
        average_sector_info(2,2,i) = 1 + realmin;
    else
        average_sector_info(:,:,i) = mean(RegionInfo{i},3);
    end
end
return