%
% function [R] = pts2binim(pts)
%
% Given some Nx2 matrix of ordered points defining a shape this function
% call will return a PxQ binary image of the shape.
%
% Example
% theta = 0:.1:2*pi;
% x = 20*cos(theta) + 30;
% y = 10*sin(theta) + 30;
% R = pts2binim([x', y']);
% imagesc(R);
% 
% Dr. A. I. Hanna (2005)
function [R] = pts2binim(pts)
R = [];
if nargin < 1
    return;
end
if size(pts,2)~=2
    fprintf('Input matrix should be of size Mx2\n');
    return;
end
W = ceil(max(pts(:,1)))+ceil(min(pts(:,1)));
H = ceil(max(pts(:,2)))+ceil(min(pts(:,2)));
% Convert x,y coordinates into image
R=zeros(W,H);
pts = [pts; pts(1,:)];
[R,xm,ym]=roipoly(R, pts(:,2), pts(:,1));
return;