function [grid] = makeShapeSprings(grid)

dist_to_shape = 5;

vert = grid.vert;
shape = grid.shape;
d = matdistance(vert, shape);
[x, y] = find(d<5);
x = cat(1, x, x(1));


% figure(1); clf; hold on;
% plot(shape(:,1), shape(:,2), '.');
% plot(vert(:,1), vert(:,2), 'rd');
% plot(vert(x,1), vert(x,2), '-gs');
% axis image ij


for i=1:length(x)-1
    p1_ind = x(i);
    p2_ind = x(i+1);
    len = norm(grid.vert(p1_ind, :) - grid.vert(p2_ind,:));
    grid.len_mat(p1_ind, p2_ind) = len;
    grid.adj_mat(p1_ind, p2_ind) = 1;
    grid.len_mat(p2_ind, p1_ind) = len;
    grid.adj_mat(p2_ind, p1_ind) = 1;   
end
return;