function [grid] = makeInternalSprings(grid)
for i=1:grid.num_regions
    ind = find(grid.region_adj_mat(i,:));
    ind = ind(ind>i);
    for j=ind
        grid.adj_mat(grid.num_ctrl_pts+i, grid.num_ctrl_pts+j) = i;
        grid.adj_mat(grid.num_ctrl_pts+j, grid.num_ctrl_pts+i) = j;
        ci = grid.vert(grid.num_ctrl_pts+i,:);
        cj = grid.vert(grid.num_ctrl_pts+j,:);
        
        d = sqrt(sum((ci-cj).^2,2));
       
        profile = getproftc(grid.R==(j+1),round(ci),round(cj),round(d));
        [val, ind] = max(profile);
        grid.len_mat(grid.num_ctrl_pts+i, grid.num_ctrl_pts+j) = ind;
        grid.len_mat(grid.num_ctrl_pts+j, grid.num_ctrl_pts+i) = d-ind;
        
     	% these lines substitute the Euclidean distance between the two centroids
        % grid.len_mat(grid.num_ctrl_pts+i, grid.num_ctrl_pts+j) = d;
        % grid.len_mat(grid.num_ctrl_pts+j, grid.num_ctrl_pts+i) = d;
    end
end
return;