function [grid] = makeExternalSprings(grid)

vert_ind = grid.spring.region_ctrl_pt_ind;
for i=1:grid.num_regions
    regind = vert_ind{i};
    for j=1:length(regind)
        p1_ind = regind(j);
        p2_ind = grid.spring.centroid_start + i;
        len = norm(grid.spring.vert(p1_ind, :) - grid.spring.vert(p2_ind,:));
        grid.spring.len_mat(p1_ind, p2_ind) = len;
        grid.spring.adj_mat(p1_ind, p2_ind) = i;
        grid.spring.len_mat(p2_ind, p1_ind) = len;
        grid.spring.adj_mat(p2_ind, p1_ind) = i;
    end
end
return;