function grid = interp_region_pts(grid)



ipts = [];
vert_ind = grid.region_ctrl_pt_ind;
num_ctrl_pts = grid.num_ctrl_pts;
num_vert = size(grid.vert,1);
already_interp_edge_id = [];
for i=1:grid.num_regions
    regind = vert_ind{i};
    regind = cat(1, regind, regind(1));
    newid = [];
    for j=1:length(regind)-1
        p1_ind = regind(j);
        p2_ind = regind(j+1);
        if isempty(already_interp_edge_id)
            e1 = 0;
            e2 = 0;
        else
            e1 = (already_interp_edge_id(:,1) == p1_ind).*(already_interp_edge_id(:,2) == p2_ind);
            e2 = (already_interp_edge_id(:,2) == p1_ind).*(already_interp_edge_id(:,1) == p2_ind);
        end
        if any(e1)==1
            newid = cat(1, newid, already_interp_edge_id(find(e1), 3));

        elseif any(e2)==1
            newid = cat(1, newid, already_interp_edge_id(find(e2), 3));
        else
            new_pt = (grid.vert(p1_ind, :) + grid.vert(p2_ind,:))/2;
            ipts = cat(1, ipts, new_pt);
            id = size(ipts,1);
            already_interp_edge_id = cat(1, already_interp_edge_id, [p1_ind, p2_ind, num_ctrl_pts + id]);
            newid = cat(1, newid, num_ctrl_pts + id);
        end

    end
    id = [regind(1:end-1), newid]';
    vert_ind{i} = id(:);
end
grid.spring.vert = [grid.vert(1:num_ctrl_pts,:); ipts; grid.vert(num_ctrl_pts+1:end,:)];
N = size(grid.spring.vert,1);
grid.spring.centroid_start = num_ctrl_pts + size(ipts,1) ;
grid.spring.region_ctrl_pt_ind = vert_ind;
grid.spring.adj_mat = zeros(N);
grid.spring.len_mat = zeros(N);


return;
