function [T, tri_pts, T_region_id] = grid2triangulation(mature_grid)
% function [T, tri_pts] = grid2triangulation(mature_grid)
%
%
% Dr. A. I. Hanna (2007)
vertices = mature_grid.control_pts;
regions_ind = mature_grid.region_ctrl_pt_ind;
centroids = mature_grid.centroids;
num_regions = length(regions_ind);
N = size(vertices,1);
tri_pts = [vertices; centroids];
T = [];
T_region_id = [];

for i=1:num_regions
    reg_ind =  regions_ind{i};
    reg_ind = [reg_ind; reg_ind(1)];
    for j=1:length(reg_ind)-1
        T = cat(1, T, [reg_ind(j) reg_ind(j+1) N+i]);
        T_region_id = cat(1, T_region_id, i);
    end
end
return;