function drawStageGrowthTensors(stage_grid, col, axish)

centroids = calcStageGridCentroids(stage_grid);
shape = stage_grid.shape;
organ_area = polyarea(shape(:,1), shape(:,2));
plot_shape(stage_grid, gca);
scale = 5*(sqrt(organ_area)/100);
GT = stage_grid.ungrowth_tensors;
for i=1:size(GT,3)
    aihGT = GT(:,:,i);
    gtlib_plotGrowthTensorCross('growth_tensor', aihGT, 'offset', centroids(i,:), 'colour', col, 'parent', axish, 'scale', scale, 'linewidth', 3);
    %gtlib_plotGrowthTensor('growth_tensor', aihGT, 'offset', centroids(i,:), 'parent', axish, 'scale', scale, 'colour', col);
end
axis image ij;
drawnow;
return;

