function [density, empty_regions, full_regions] = calcDeficientRegions(T, pts, regions_ind, xydata, min_number_sectors)
% function [density, empty_regions] = calcDeficientRegions(T, pts, regions_ind, xydata)
%
%
% Dr. A. I. Hanna (2007)
num_regions = length(regions_ind);
density = zeros(num_regions,1);
tid = tsearch(pts(:,1), pts(:,2), T, xydata(1,:), xydata(2,:));
for i=1:length(regions_ind)
    rind = regions_ind{i};
    for ii=1:length(rind)
        density(i) = density(i)+sum(tid==rind(ii));
    end
end
min_density = min_number_sectors;
empty_regions = find(density<min_density)';
full_regions = setdiff([1:length(density)], empty_regions);
l = [];
for i = empty_regions
    l = cat(1, l, length(regions_ind{i}));
end
[val, ind] = sort(l ,'ascend');
empty_regions = empty_regions(ind);
return;