
function [] = show_variance_in_orientation(mean_shape_dir, stage_dir)
STAGE_DIR = 'Staged';
if ~checkSATDir(pwd)
    fprintf('Not a valid Sector Analysis project!\n');
    return;
end
d = dir(STAGE_DIR);
str = {d.name};
% If the user does not pass a stage directory then ask for one.
if nargin<2
    [s,v] = listdlg('ListSize', [300 300], 'Name', 'Stages to calculate orientation', 'PromptString','Select the stages you want to analyze:','SelectionMode','multiple','ListString',str);
    if v == 0
        fprintf('Sorry not a valid SectorAnalysis project directory\n');
        return;
    end
    stage_dirs =  {str{s}};
end
if nargin<1
    [s,v] = listdlg('ListSize', [300 300], 'Name', 'Mean Organ Shape Directory', 'PromptString','Select mean organ shape directory:','SelectionMode','single','ListString',str);
    if v == 0
        fprintf('Must choose location of your mean shape\n');
        return;
    end
    mean_shape_dir =   ['Staged', filesep,  str{s}];
end
region_num = 7;
grid = 'region_info_grid_data_5_by_5.mat';



for s = 1:length(stage_dirs)
    stage = [STAGE_DIR, filesep, stage_dirs{s}];
    files = FindFilenames(grid, stage);
    Orientation{s} = [];
    for f = 1:length(files)
        info = load(files{f});
        info = info.RegionInfo;
        if ~isempty(info{region_num})
            Orientation{s} = [Orientation{s}; info{region_num}(:,6)];
        end
    end
end
for i=1:length(Orientation)
   figure
   o = Orientation{i};
   %ind = find(o<0);
   %o(ind) = o(ind) + 2*pi;
   ind = find(o==0);
   o(ind) = [];
   [n(i,:), x(i, :)] = hist(o, 20);
   bar(x(i,:), n(i,:));
end
return;
