%
% show_stage_sector_info(mean_shape_dir, stage_dir)
%
% Dr. A. I. Hanna (2005);
function show_stage_sector_info(mean_shape_dir, stage_dir)
if ~checkSATDir(pwd)
    fprintf('Not a valid Sector Analysis project!\n');
    return;
end
% Set up some directory constants
stagedDir = 'Staged';
dataDir = [stagedDir, filesep, 'Data'];
gridDir = [dataDir, filesep, 'Grids'];
d = dir(stagedDir);
str = {d.name};
if nargin<1
    [s,v] = listdlg('PromptString','Select mean organ shape directory:','SelectionMode','single','ListString',str);
    if v == 0
        fprintf('Must choose location of your mean shape\n');
        return;
    end
    mean_shape_dir =   [stagedDir, filesep,  str{s}];
end


if nargin<2
    [s,v] = listdlg('Name', 'Stage Selection Dialog', 'ListSize', [300 200], 'PromptString','Select a stage to display:','SelectionMode','single','ListString',str);
    if v == 0
        fprintf('Sorry not a valid SectorAnalysis project directory\n');
        return;
    end
    stage_dir =   [stagedDir, filesep,  str{s}];
end
figure;%(1); clf; 
set(gcf, 'Pos', [196         519        1466         422]);
set(gcf, 'Name', ['Information for stage ', stage_dir]);
filesJPG = FindFilenames('JPG', stage_dir);
filesjpg = FindFilenames('jpg', stage_dir);
files = [filesJPG, filesjpg];
file = files{1};
I = imread(file);
subplot(2,2,1);
imagesc(I); axis image ij;
title('Example image from stage');
subplot(2,2,[2,4]);
title('Mean shape and warped sectors for stage');
show_sectors_for_stage(gca, stage_dir, mean_shape_dir);
ppc = get_pixel_per_cell_value;
[n, x] = get_warped_stage_data(stage_dir, ppc);
axis image ij;
subplot(2,2,3);
class=[0 16; 16 32; 32 64; 64 128; 128 256; 256 512; 512 1024; 1024 2048; 2048 5096; 5096 10192; ...
    10192 20384; 20384 40768; 40768 81536; 81536 300000];
map = jet(size(class,1));
map = flipud(map);
barmap = zeros(length(n),3);
for i=1:length(n)
    a= (2^n(i))*ppc;
    found_class = (a>=class(:,1))+ (a<=class(:,2))==2;
    barmap(i,:) = map(found_class,:);
end
cbar(n, x, barmap);
axis([min(n) max(n) 0 max(x)]);
xlabel('number of cells as 2^x');
ylabel('number of sectors');
grid on;
title('Distribution of sector sizes');
