%
% show_average_ellipses_for_stage(mean_shape_dir, stage_dir)
%
% Dr. A. I. Hanna (2005);
function show_average_ellipses_for_stage(mean_shape_dir, stage_dir)
if ~checkSATDir(pwd)
    fprintf('Not a valid Sector Analysis project!\n');
    return;
end
% Set up some directory constants
stagedDir = ['Staged'];
dataDir = [stagedDir, filesep, 'Data'];
gridDir = [dataDir, filesep, 'Grids'];

d = dir(gridDir);
str = {d.name};
[s,v] = listdlg('PromptString','Select a grid:','SelectionMode','single','ListSize', [300 300], 'ListString',str);
if v == 0
    fprintf('Sorry not a valid SectorAnalysis project directory\n');
    return;
end
average_sector_data = str{s};
grid_info = load([gridDir, filesep, average_sector_data]);
num_stages = length(grid_info.stage_grids);
stage_str = cell(num_stages,1);
for i=1:num_stages
    stage_str{i} = [grid_info.stage_grids{i}.stage_info.prev, '_', grid_info.stage_grids{i}.stage_info.post];
end
[s,v] = listdlg('PromptString','Select a stage:','SelectionMode','single','ListString',stage_str);
if v == 0
    return;
end

curr_grid = grid_info.stage_grids{s};
ellipcol = [1 1 1];
scale = 5;
centroids = calcStageGridCentroids(curr_grid);
figure;
set(gca, 'Clipping', 'on');
plot_grid(curr_grid);
hold(gca, 'on');
axis image ij;
info = curr_grid.average_sectors.prev;
map = jet(ceil(max(info(:,3))));
for ii=1:size(info,3)
    [maj, min, theta] = gtlib_growthTensor2Params(info(:,:,ii));
    ei.Orientation = theta;
    ei.MajorAxisLength = maj;
    ei.MinorAxisLength = min;
    ei.Centroid = centroids(ii,:);
    ei.Area = pi*maj*min;
    gtlib_plotGrowthTensor('growth_tensor', info(:,:,ii), 'offset', ei.Centroid, 'colour', ellipcol, 'parent', gca, 'scale', scale, 'linewidth', 3);
    % text(ei.Centroid(1)-20, ei.Centroid(2), sprintf('%s\n%s\n%s\n%s\n%s', num2str(ii), ['major = ', num2str(maj)], ['minor = ', num2str(min)], ['\theta = ', num2str(theta)], ['area = ', num2str(pi*maj*min)]), 'FontSize', 8, 'Clipping', 'on');
end
title(curr_grid.stage_info.prev, 'Interpreter', 'none');
grid on;

return




d = dir(stagedDir);
str = {d.name};
if nargin<1
    [s,v] = listdlg('PromptString','Select mean organ shape directory:','SelectionMode','single','ListString',str);
    if v == 0
        fprintf('Must choose location of your mean shape\n');
        return;
    end
    mean_shape_dir =   [stagedDir, filesep,  str{s}];
end
if nargin<2
    [s,v] = listdlg('PromptString','Select a file:','SelectionMode','single','ListString',str);
    if v == 0
        fprintf('Sorry not a valid SectorAnalysis project directory\n');
        return;
    end
    stage_dir =   [stagedDir, filesep,  str{s}];
end




d = dir(gridDir);
str = {d.name};
[s,v] = listdlg('PromptString','Select a grid:','SelectionMode','single','ListSize', [300 300], 'ListString',str);
if v == 0
    fprintf('Sorry not a valid SectorAnalysis project directory\n');
    return;
end
average_sector_data = str{s};


% info = load([stage_dir,filesep, average_sector_data]);
% info = info.average_sector_info;
% if ~exist([gridDir, filesep, average_sector_data(21:end)],'file')
%     fprintf('Sorry could not find grid information %s.\n', [gridDir, filesep, average_sector_data(21:end)]);
%     return;
% end
figure;%(1); clf;
hold on;
set(gcf, 'Name', ['Information for stage ', stage_dir]);
grid_info = load([gridDir, filesep, average_sector_data]);
plot_grid(grid_info.region_info);

%grid_outline = grid_info.region_info.grid_xy;
%plot(grid_outline(:,2), grid_outline(:,1), '.');
%plot_mean_shape(gca, mean_shape_dir);
axis image ij;
scale = 3;
avinfo = grid_info.average_region_info;
for i=1:length(avinfo)
    if strcmp(avinfo{i}.stage, stage_dir)
        info = avinfo{i};

    end
end

for i=1:size(info.average_stage_sector_info, 3)
    T = info.average_stage_sector_info(:,:,i);
    eh = gtlib_plotGrowthTensor('growth_tensor', T, 'offset', grid_info.region_info.centroids(i,:), 'scale', scale);
    %     ei.Orientation = info(i, 6);
    %     ei.MajorAxisLength = info(i, 4)*scale;
    %     ei.MinorAxisLength = info(i, 5)*scale;
    %     ei.Centroid = info(i,1:2)';
    %     ei.Area = info(i, 3);
    %     eh = plot_ellipse(gca, ei);
end
title(['Average Growth Tensors for stage ', stage_dir], 'Interpreter', 'none');
