function [] = show_all_stages(mean_shape_dir)
stagedDir = ['Staged'];
dataDir = [stagedDir, filesep, 'Data'];
gridDir = [dataDir, filesep, 'Grids'];

d = dir(stagedDir);
str = {d.name};
if nargin<1
    [s,v] = listdlg('PromptString','Select mean organ shape directory:','SelectionMode','single','ListString',str);
    if v == 0
        fprintf('Must choose location of your mean shape\n');
        return;
    end
    mean_shape_dir = [stagedDir, filesep,  str{s}];
end
files = dir(stagedDir);
files = {files.name};
ind = [];
for f = 1:length(files)
    file = files{f};
    if (file(1) == '.') | strcmp(file, 'Data')
        ind = [ind; f];
    end
end
files(ind) = [];
%stage_dir =   [stagedDir, filesep,  str{s}];
N = length(files);
M = ceil(N/4);
N = 4;
figure;%(1); clf; %iptsetpref('ImshowBorder', 'tight');
c = 1;
for i=1:length(files)
    subaxis(N, M, c,'Spacing',.01, 'MR', .1);
    %set(gca, 'Visible', 'off');
    title(files{i});
    show_sectors_for_stage(gca, [stagedDir, filesep, files{i}], mean_shape_dir);
    title(files{i});
    set(gca, 'XTickLabel', [], 'YTickLabel', []);
    grid on;
    c = c+1;
end