function satlib_plot_region_patches(varargin)

data = parseargs(varargin);

for r=1:length(data.tri_region_ind)
    region_tri_ind = data.tri_region_ind{r};
    region_tri = data.T(region_tri_ind,:);
    col = data.tri_col(r, :);
    for t = 1:size(region_tri,1)
        rpts = data.pts(region_tri(t,:),:);
        p = patch(rpts(:,1), rpts(:,2), 'r', 'EdgeColor', data.edgecol, 'parent', data.axish, 'LineWidth', data.linewidth);
        set(p, 'FaceColor', col);
    end
end

%%
%
function data = parseargs(varargin)
varargin = varargin{1};
if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error('Arguments to show_region_areal_growth must come param/value in pairs.')
end

data.tri_region_ind = [];
data.T = [];
data.pts = [];
data.axish = [];
data.tri_col = [];
data.edgecol = [0 0 0];
data.linewidth = 1;
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'linewidth'
            data.linewidth = varargin{i+1};
        case 'regions'
            data.tri_region_ind = varargin{i+1};
        case 't'
            data.T = varargin{i+1};
        case 'pts'
            data.pts = varargin{i+1};
        case 'facecolours'
            data.tri_col = varargin{i+1};
        case 'edgecolor'
            data.edgecol = varargin{i+1};
        case 'parent'
            data.axish = varargin{i+1};
        otherwise
            error(['Unknown parameter name passed to ', mfilename, ' show_region_areal_growth.  Name was ' varargin{i}])
    end
end
if isempty(data.axish)
    data.axish = gca;
end
if isempty(data.T)
    error('Parameter T must be supplied');
end
[N, M] = size(data.T);
if isempty(data.tri_col)
    data.tri_col = ones(N,3);
    data.tri_col(:,1:2) = 0;
end
if size(data.tri_col, 1) == 1
    data.tri_col = repmat(data.tri_col, [N, 1]);
end
return