function figvec = satlib_drawRegions(varargin)
% function figvec = satlib_drawRegions(varargin)
%
% Dr. A. I. Hanna, CMP, 2008.
data = parseargs(varargin);

figvec = [];
M = 1;
N = 1;
indx = 1;
window_id = 1;
figh = figure;
figvec = cat(1, figvec, figh);
clf(figh); set(figh, 'Color', data.figcol, 'Colormap', data.colormap);
set(figh, 'Name', [data.title, ': ', num2str(window_id)]);
for i=1:length(data.ug)
    if indx>(M*N)
        window_id = window_id + 1;
        figh = figure;
        figvec = cat(1, figvec, figh);
        set(figh, 'Name', [data.title, ': ', num2str(window_id)]);
        set(figh, 'Color', data.figcol, 'Colormap', data.colormap);
        indx = 1;
    end
    axish = subplot(M, N, indx); indx = indx + 1;
    hold on;
 
    satlib_drawGridData('grid', data.ug{i}, 'colours', data.colours{i}, 'EdgeColor',  data.edgecolor,...
        'parent', axish, 'showtensors', data.showtensors, 'tensorcol', data.tensorcol, ...
        'tensorscalefactor', data.tensorscalefactor, 'tensorthreshold', data.tensorthreshold,...
        'linewidth', data.linewidth, 'tensoruniscale', data.tensoruniscale, 'tensortype', data.tensortype);
    if ~strcmpi(data.outlinecol, 'none')
        triplotedges(data.boundary, data.ug{i}.tri_info.pts, data.linewidth, data.outlinecol);
      %  outline = data.ug{i}.shape;
      %  outline = cat(1, outline, outline(1,:));
      %  plot(axish, outline(:,1), outline(:,2), '-', 'Color', data.outlinecol, 'LineWidth', 2);
    end
    if data.scale
        if (indx==2) && (window_id==1)
            axis image ij;
            xlim = get(gca, 'XLim');
            ylim = get(gca, 'YLim');

        else
            axis image ij;
            set(gca, 'XLim', xlim, 'YLim', ylim);
        end
    else
        axis image ij;
    end
    set(gca, 'visible', 'off');
    cb = colorbar('SouthOutside', 'peer', gca);
    alim = get(cb, 'ALim');
    labels = linspace(data.collims(1), data.collims(2), length(get(cb, 'XTickLabel')));
    set(cb, 'XTickLabel', labels, 'XTickMode', 'manual');
end
return;
%%
%
function data = parseargs(varargin)
varargin = varargin{1};
if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error('Arguments to show_region_areal_growth must come param/value in pairs.')
end
data.tensortype = [1 1];
data.figcol = [1 1 1];
data.title = '';
data.colours = [];
data.scale = 1;
data.boundary = [];
data.edgecolor = 'k';
data.showtensors = 1;
data.outlinecol = 0;
data.tensorcol = 'k';
data.colormap = jet(256);
data.collims = [0 1];
data.linewidth = 1;
data.tensorscalefactor = 1;
data.tensorthreshold = 0;
data.tensoruniscale = 0;
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'tensortype'
            data.tensortype = varargin{i+1};
        case 'tensoruniscale'
            data.tensoruniscale =varargin{i+1};
         case 'tensorscalefactor'
            data.tensorscalefactor = varargin{i+1};
        case 'tensorthreshold'
            data.tensorthreshold = varargin{i+1};
        case 'boundary'
            data.boundary = varargin{i+1};
        case 'figcol'
            data.figcol = varargin{i+1};
        case 'grids'
            data.ug = varargin{i+1};
        case 'colours'
            data.colours = varargin{i+1};
        case 'scale'
            data.scale = varargin{i+1};
        case 'title'
            data.title = varargin{i+1};
        case 'edgecolor'
            data.edgecolor = varargin{i+1};
        case 'showtensors'
            data.showtensors = varargin{i+1};
        case 'outlinecolour'
            data.outlinecol = varargin{i+1};
        case 'tensorcol'
            data.tensorcol = varargin{i+1};
        case 'colormap'
            data.colormap = varargin{i+1};
        case 'collims'
            data.collims = varargin{i+1};
        case 'linewidth'
            data.linewidth = varargin{i+1};
        otherwise
            error(['Unknown parameter name passed to ', mfilename, ' show_region_areal_growth.  Name was ' varargin{i}])
    end
end
if isempty(data.colours)
    col{1} = [0 1 0];
    data.colours = repmat(col, [size(data.ug,1),1]);
end
if strcmpi(data.colours, 'none')
    col{1} = data.colours;
    data.colours = repmat(col, [size(data.ug,1),1]);
end
if ~iscell(data.colours)
    col{1} = data.colours(1,1:3);
    data.colours = repmat(col, [size(data.ug,1),1]);
end
return