function [D] = satio_meshes2GrowthData(g1, g2, deltaSt)
tri_info1 = g1.tri_info;
tri_info2 = g2.tri_info;
N = size(tri_info1.T,1);
D = zeros(3,3,N);
for t = 1:N
   tri =  tri_info1.T(t,:);
   pts1 = gtlib_interp_tri_pts(tri_info1.pts(tri,:));
   pts2 =  gtlib_interp_tri_pts(tri_info2.pts(tri,:));
   pts1 = pts1 - ones(size(pts1,1),1)*mean(pts1);
   pts2 = pts2 - ones(size(pts2,1),1)*mean(pts2);
   [growthparams, e1, e2, theta] = gtlib_svd2growthparams(pts2, pts1, deltaSt);
   D(:,:,t) = gtlib_growthParams2Tensor(e1, e2, theta);
end
return