function varargout = satio_load_warped_sector_info(varargin)
% function varargout = satio_load_warped_sector_info(varargin)
%
% IO Method for loading warped sector data in the SA toolbox
%
% Usages: 
% warped_sector_info = satio_load_warped_sector_info('organ_directory', direc);
% or 
% warped_sector_info = satio_load_warped_sector_info;
%
%
% See also: satio_list
%
% Dr. A. I. Hanna (2007)
error(nargchk(0,inf,nargin));
warped_sector_info = [];
staged_dir = [pwd, filesep,'Staged', filesep];
filename = '';
if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error(['Arguments to ', mfilename, ' must come param/value in pairs.'])
end
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'filename'
            filename = varargin{i+1};
        otherwise
            error(['Unknown parameter name passed to ', mfilename, '.  Name was ' varargin{i}])
    end
end
if isempty(filename)
    [organ_dir] = uigetdir(staged_dir, 'Open Organ Directory');
    if isequal(organ_dir,0)
        disp('User pressed cancel');
        varargout{1} = [];
        varargout{2} = organ_dir;
        return;
    end
end
warped_sector_info_filename = [organ_dir, filesep, 'warped_sector_info.mat'];
if exist(warped_sector_info_filename, 'file')
    warped_sector_info = load(warped_sector_info_filename);
    warped_sector_info = warped_sector_info.warped_sector_info;
else
    fprintf('i/o error: could not find file %s\n', warped_sector_info_filename);
    varargout{1} = [];
    varargout{2} = organ_dir;
end
varargout{1} = warped_sector_info;
varargout{2} = organ_dir;
return



