function mean_shape = satio_load_mean_shape
% function satio_load_mean_shape
%
% A method that loads the mean shape for the current project, if the mean
% shape does not exist, the function returns an empty matrix.
%
%
% See also: satio_list
%
% Dr. A. I. Hanna (2007)

mean_shape_filename = [pwd, filesep, 'Staged', filesep, 'Data', filesep, 'mean_shape.mat'];
mean_shape = [];
if exist(mean_shape_filename, 'file')
    mean_shape = load(mean_shape_filename);
    if isfield(mean_shape, 'mean_shape')
        mean_shape = mean_shape.mean_shape;
        return;
    end
end
return
        