% IMBATCHRESIZE resises a batch of imsge files of type JPG, TIF, GIF, BMP
% and PNG.
%
% syntax:
%       imBatchResize(option)
%
% description:
%       resizes images using opiton arguments of the imresize function of
%       matlab. Images are saved in the same format as the original file
%       and in a subdirectory named ResizedImage. A postfix '_resized' is
%       added to the original name of the file
%
%
% see also imresize
%
% Dr. Blot (Dec. 2006)
%

function imBatchResize(varargin);
dirName=uigetdir(pwd,'select image directory')
imgFiles=[];
index=1;
if dirName
   files=dir(dirName);%'*.jpg,*.tif,*.gif,*.bmp,*.png'
   for i=1:length(files)
       [fpath,fname,fext,fver]=fileparts(files(i).name);
       if length(fext)>1
           fext=fext(2:end);
       end
       if ~isempty(strfind('jpg,tif,gif,bmp,png,jpeg,tiff',lower(fext)))
           imgFiles{index}=files(i);
           files(i)
           index=index+1;
       end
   end
end

if ~exist([dirName,filesep,'ResizedImage'],'dir')
   mkdir([dirName,filesep,'ResizedImage']);
end
for i=1:length(imgFiles)
   [fpath,fname,fext,fver]=fileparts(imgFiles{i}.name);
   info=imfinfo(fullfile(dirName,imgFiles{i}.name));
   I=imread(fullfile(dirName,imgFiles{i}.name));
   Ir=imresize(I,varargin{:});
   imwrite(Ir,fullfile(dirName,'ResizedImage',[fname,'_resized',fext]),info.Format);
end
