% IMBATCHCROP crops a batch of image files of type JPG, TIF, GIF, BMP
% and PNG.
% 
% syntax:
%       imBatchCrop(rect)
% 
% description:
%       imBatchCrop crops batch of images to a specified rectangle. Images
%       are saved in the same format as the original file and in a
%       subdirectory named CroppedImage. A postfix '_cropped' is added to
%       the original name of the file.
% 
%       rect is a four-element vector with the form [xmin ymin width height];
%       these values are specified in spatial coordinates.
% 
%       fmt is the image format of the ouput images.
% 
%  Note: to obtain 256x256 images with top left corner at position (100,50)
%  the parameter rect should be rect = [100 50 255 255].
% 
% 
% see also imcrop
% 
% Dr. Blot (Dec. 2006)
% 

function imBatchCrop(rect,fmt);
dirName=uigetdir(pwd,'select image directory')
imgFiles=[];
index=1;
if dirName
    files=dir(dirName);%'*.jpg,*.tif,*.gif,*.bmp,*.png'
    for i=1:length(files)
        [fpath,fname,fext,fver]=fileparts(files(i).name);
        if length(fext)>1
            fext=fext(2:end);
        end
        if ~isempty(strfind('jpg,tif,gif,bmp,png,jpeg,tiff',lower(fext)))
            imgFiles{index}=files(i);
            files(i)
            index=index+1;
        end
    end
end

if ~exist([dirName,filesep,'CroppedImage'],'dir')
    mkdir([dirName,filesep,'CroppedImage']);
end
for i=1:length(imgFiles)
    [fpath,fname,fext,fver]=fileparts(imgFiles{i}.name);
    info=imfinfo(fullfile(dirName,imgFiles{i}.name));
    I=imread(fullfile(dirName,imgFiles{i}.name));
    if size(I,3)==1
        Im(:,:,1)=I;
        Im(:,:,2)=I;
        Im(:,:,3)=I;
    end
    Ir=imcrop(Im,rect);
    imwrite(Ir,fullfile(dirName,'CroppedImage',[fname,'_cropped.',fmt]),fmt);
end
