function [volume] = loadVolumeFromSlicesDir(fullVolumePath, scale)
% function [volume] = loadVolumeFromSlicesDir(fullVolumePath)
% 
% Description:
% Function to load slices given the directory where the slices reside. The
% matlab supported image formats are tried in turn to load a volume
% comprising image slices in the given directory. As soon as one or more
% image files of a given type are encounterd, all the images with the given
% extension are assumed to comprise the volume and image search stops.
% 
% Author: Johann Strasser
% Date: 070326
if nargin<2
    scale = 1;
end
volume = [];

imf = imformats;
formatCounter = 1;

% Scan through the matlab supported image formats and check if directory
% contains images, if yes load slices
while isempty(volume) && formatCounter <= length(imf)
    
    extensionCounter = 1;
    
    while isempty(volume) && extensionCounter <= length(imf(formatCounter).ext)
        
        volume = loadVolumeFromSlicesDirTyped(fullVolumePath, ...
            char(imf(formatCounter).ext{extensionCounter}), scale);
        extensionCounter = extensionCounter + 1;
    end
    
    formatCounter = formatCounter + 1;
end