function [transformsOut, volumesOut, pointSetsOut] =...
    hapticTool(transforms, volumes, pointSets)
%   [transformsOut, volumesOut, pointSetsOut] =...
%     hapticTool(transforms, volumes, pointSets)
%   A 3d haptic point editor based on H3DApi.
%  
%   Author: Johann Strasser
%   Date: 061123 (YYMMDD)
%
%   Revision #1

for i = 1:size(volumes, 2)
    dims = size(volumes(i).volume);
    volumes(i).volume = shiftdim(volumes(i).volume, 3);
    volumes(i).volume = reshape(volumes(i).volume, dims);
end

debug = 0;

if debug

% Use the release version of the mex-file
 [transformsOut, volumesOut, pointSetsOut] =...
    hapticToolMexd(transforms, volumes, pointSets);

% Clear the native function. This is necessary to circumvent the
% disappearing fonts issue, where fonts are not rendered on repeated
% execution of the native hapticTool function. Without invoking clear after
% each call only the first invokation displays the ftgl fonts used by
% H3DApi. The reasons for this are unknown.
clear hapticToolMexd;
else
    
% Use the debug version of the mex-file
 [transformsOut, volumesOut, pointSetsOut] =...
    hapticToolMex(transforms, volumes, pointSets);

% Clear the native function. This is necessary to circumvent the
% disappearing fonts issue, where fonts are not rendered on repeated
% execution of the native hapticTool function. Without invoking clear after
% each call only the first invokation displays the ftgl fonts used by
% H3DApi. The reasons for this are unknown.
clear hapticToolMex;
end


