 % Convert the loops and primaries field to the coordIndices array
    % required by the indexedLineSet to be passed to hapticTool.
    % Furthermore vertex and line colours need to be derived
    % Rules for conversion:
    % The loops vector contains all the polyline segments without
    % polyline delineation
    % Consecutive primaries are the end points of a polyline and are
    % are coloured differently
    lineIndices = [-1];
    vertexColours = [];
    lineColours = [];
    
    primariesCounter = 2;
    
    % Note that loops is an n x 2 matrix. Considering the conversion from
    % the native to the PMTemplate formate, all we need to do is use the
    % first column and insert delimiters whenever we are at a primary
    % vertex.
    for i = 1:size(loops, 1)
        index = loops(i, 1);
        lineIndices = [lineIndices, index];
        
        if index == primaries(primariesCounter)
            lineIndices = [lineIndices, -1];
            primariesCounter = primariesCounter + 1;
        end
    end
    
    % Last vertex last row column 2 !
    lastIndex = loops(size(loops, 1), 2);
    lineIndices = [lineIndices, lastIndex, -1];
    
    if lastIndex ~= primaries(length(primaries))
        error(sprintf(['TemplateBuilder3DTool: Inconsistent primary/loop structures encountered. \n', ...
       'during conversion to hapticTool native format.']));
    end