function [c] = tri_center(t)
% function [c] = tri_center(t)
%
% A function that returns the center of a triangle specified by t
%
% Input Params:
%  t - a 3x2 matrix that defines a triangle.
%
% Output Params:
%  c - the [x, y] position of the center of the triangle.
%
% Dr. A. I. Hanna (2006);
if nargin <1
    error('need at least one input matrix');
    return;
end
if ~all(size(t) == [3, 2])
    error('input matrix should be 3x2');
    return;
end
c = sum(t)/3;
