function [pts, P] = splitPoints(pts, segpoint, offsets)
% function pts = splitPoints(pts, segpoint, offsets)
%
% This function takes a NxD point model, where N is the number of points
% and D is the dimension. Given an array of segment points and a set of
% offsets it returns the set of points translated and rotated by the values
% in offsets ready for drawing.
%
% See also: isAugmentedProject
%
% Dr. A. I. Hanna (2007)
segpoint = [0; segpoint; size(pts,1)];
P = {};
for i=2:length(segpoint)
    shape_pts = pts(segpoint(i-1)+1:segpoint(i),:);
    [shape_pts] = trans_rot_points(shape_pts', offsets(i-1,1:2)', offsets(i-1,3))';
    P{i-1} = shape_pts;
end
pts = [];
for i=1:length(P)
    pts = [pts; P{i}];
end
return;