function [X] = load_group_pointmodels(templatename, pm_files, prj_name)
% function [X] = load_group_pointmodels(templatename, pm_files, prj_name)
%
% Dr. A. I. Hanna (2006)
point_model_dir = 'PointModels';
if nargin<3
    prefix = [point_model_dir, filesep, templatename, filesep];
else

    prefix = [point_model_dir, filesep, templatename, filesep, prj_name, '_'];
end
X = [];
for i=1:length(pm_files)
    if exist([prefix, pm_files{i}], 'file')
        l = load([prefix, pm_files{i}]);
        X(:,end+1) = l.pts;
    else
        fprintf('Could not file file %s\n', [prefix, pm_files{i}]);
    end
end