function triOut = removeOutsideFaces(tri, points, polygonVertices)
% function triOut = removeOutsideFaces(tri, points, polygonVertices)
%
% tri, the original triangulation data structure, indexing into 
% points, the triangulated point cloud.
% polygonVertices, the vetex list defining the polygon which may be
%                  concave. The third argument is a subset of the second
%                  argument
% triOut, the new triangle list which corresponds to tri with all 
%         the triangles lying outside the polygon specified by
%         polygonVertices removed
  

[rows, columns] = size(tri);
triOutRow = 1;

for triRow = 1:rows
    %Calculate the centeroid

    centeroid = sum(points(tri(triRow,:), :))/3;

    in = inpolygon(centeroid(1), centeroid(2), polygonVertices(:, 1), polygonVertices(:, 2));
    if in
        triOut(triOutRow, :) = tri(triRow, :);
        triOutRow = triOutRow + 1;
    end
end