
function s = student(t,n)
%STUDENT Student's t-distribution.
% S = STUDENT(T,N) gives the significance level S for a
% given value of statistic T and degrees of freedom N
% for a two-sided definition:
%
%                             /t
%                           1 |     x^2
% A(t|n) = ------------------ |(1 + ---)^((1+n)/2) dx
%          sqrt(n)*B(1/2,n/2) |      n
%                             /-t
%
%
% Formula from W. H. Press, et. al., "Numerical Recipes
% in C", Cambridge: Cambridge, 1988, p. 180 - 181.
error(nargchk(2,2,nargin));
s = 1 - betainc(n./(n+t.^2),0.5*n,0.5);