function [X] = project2tangentspace(X, meanshape)
% function [X] = pcalib_project2tangentspace(X, meanshape)
% 
% A function that maps the aligned shapes in X to the tangent space given
% by meanshape.
%
% Inputs: 
%          X - a MxN matrix where M is the dimension of the shape, and N is the number of samples.
%              NOTE: X is of the form X = [x_1, y_1, x_2, y_2, ..., x_N, y_N]'.
%  meanshape - this is the meanshape in question that defines the
%              projection onto the tangent space. It is a column vector with the same
%              structure as the columns in X.
% Outputs:
%         X - the same structure as the input X, but the shapes have now
%             been projected into the tangent space.
%
% Dr. A. I. Hanna (2006).
meanshape = meanshape(:);
for i=1:size(X,2)
   x = X(:,i);
   scale = (meanshape'*meanshape)/(meanshape'*x);
   X(:,i) = x*scale; 
end
return