function [pts]=general_smoothlandmarks(pts,pri,edges);
if(length(pri) <= 1)
    uiwait(msgbox(sprintf('You need at leat two primary points')))
    return;
end
segments=find_segments_to_smooth(pts,pri,edges);
for k = 1:length(segments) %SectionsToSmooth
    seg=segments{k};
    NptsThisSection=length(seg);
    x=pts(seg,1);
    y=pts(seg,2);
    % x,y are start and end points of the spline
    Nint = 50;
    t = 1:NptsThisSection;
    ts = 1:1/Nint:NptsThisSection;
    xfit = spline(t, x, ts); % x-coordinates of interpolating line
    yfit = spline(t, y, ts); % y-coordinates of interpolating line
    % Calculate the length of the line through the secondaries
    xfitS = xfit(2:length(xfit)) - xfit(1:length(xfit)-1);
    yfitS = yfit(2:length(yfit)) - yfit(1:length(yfit)-1);
    LineLength = cumsum(sqrt((xfitS.^2) + (yfitS.^2)));
    % Calculate what the spacing should be between the secondaries.
    DistanceBetweenPoints = LineLength(length(LineLength)) / (NptsThisSection - 1);
    % Clear from last iteration
    newx=[]; newy=[];
    % Find position of new points
    for n = 2:NptsThisSection-1
        idx = min(find(LineLength >= (n-1) * DistanceBetweenPoints)) + 1;
        newx(n-1) = xfit(idx);
        newy(n-1) = yfit(idx);
    end
    pts(seg(2:end-1),1) = newx';
    pts(seg(2:end-1),2) = newy';
end