function [N,NC]=document_toolbox(type,cwd)
%
%type, 0 (default) count lines in all m files (recursively down directory)
%      1 store list of filenames in toolbox_m_file_help.txt
%      2 store help files in toolbox_m_file_help.txt
%      3 store listings in toolbox_m_file_help.txt
%cwd,  root directory (from which recursion will start)
%        (default is pwd)
%
%N,    number of lines
%NC,   number of characters

if nargin<1
    type=1;
end
if nargin<2
    cwd=pwd;
end
[N,NC]=counter(cwd,type);
disp(sprintf('Total number of program lines %d and %d characters',N,NC))
disp('Book equivalent')
cw=5;
wl=12;
lp=50;
disp(sprintf('At %d chars per word, %d words per line and %d lines per page',cw,wl,lp))
disp(sprintf('The toolbox is equivalent to a %d page book, excluding figures',round(NC/(cw*wl*lp))));


function [N,NC]=counter(cwd,type)
if nargin<1
    cwd=pwd;
end
if nargin<2
    type=0;
end
if type>0
    diary toolbox_m_file_help
end
dd=dir(cwd);
N=0;
NC=0;
for j=3:length(dd)
    if dd(j).isdir
        if type==0
            disp(sprintf('Looking into %s',fullfile(cwd,dd(j).name)))
        end
        [NN,NCC]=counter(fullfile(cwd,dd(j).name),type);
        N=N+NN;
        NC=NC+NCC;
        if type==0
            disp(sprintf('%s had %d lines and %d characters',fullfile(cwd,dd(j).name),N,NC))
        end
    end
    n=0;
    nc=0;
    name=dd(j).name;
    if findstr(name,'.m')
        tempname=name(1:findstr(name,'.m')+1);
        if exist(tempname)==2
            h=fopen(tempname,'r');
            while ~feof(h)
                s=fgets(h);
                n=n+1;
                nc=nc+length(s);
            end
            fclose(h);
            if type==0
                disp(sprintf('    %s has %d lines and =%d chars',fullfile(cwd,name),n,nc));
            elseif type==1
                disp(' ');
                disp(sprintf('    %s ',fullfile(cwd,name)));
            else%if type==1
                disp('------------')
                disp(' ');
                disp(sprintf('    %s ',fullfile(cwd,name)));
                disp(' ');
                help(fullfile(cwd,name));
            end
            N=N+n;
            NC=NC+nc;
        end
    end
end
if type>0
    diary off
end

