function aamlib_pm_classifier(menu, evd)
% function aamlib_pm_classifier
%
% This function is used to write an excel file that contains the
% classification of point models against selected groups. The user has to
% first select the groups to classify against, then they have to pick the
% groups whose elements they want to classify.
%
% Dr. A. I. Hanna (2007)

% get the default parameters for each algorithm
params = getAlgorithmParameters;

% first load in the groups that we intend to classify against.
classgroups = selectGroups('Select Groups to Classify Against:');
if isempty(classgroups)
    return;
end

% load the groups whose elements we want to classify
datagroups = selectGroups('Select Groups to Classify:');
if isempty(datagroups)
    return;
end

% get the Excel file to write to
[xlsfilename, xlspathname] = uiputfile('*.xls', 'Pick an Excel-file');
if isequal(xlsfilename,0) || isequal(xlspathname,0)
    disp('User pressed cancel')
    return;
end
xlsfilename = [xlspathname, filesep, xlsfilename];

% for each of the classification methods, process and save to an excel
% sheet.
methds = {'gaussian', 'parzengauss', 'knn', 'nn'};
wh = waitbar(0, 'Processing...');
for a = 1:length(methds)
    XLS_DATA = output2cell(datagroups, classgroups, methds{a}, params{a});
    [success, message] = xlswrite(xlsfilename, XLS_DATA, ['Sheet', num2str(a)]);
    waitbar(a/length(methds), wh);
end
delete(wh);
return;
%%%
%
%%%
function XLS_DATA = output2cell(datagroups, classgroups, mth, params)
XLS_DATA = {};
XLS_DATA{1,1} = 'Point Model Name';
XLS_DATA{1,2} = 'Group Classification';
idx = 2;
for i=1:length(datagroups)
    X = [datagroups(i).shapedata(:).b];
    pm_names = datagroups(i).elements;
    [labels, d, str] = ammlib_groupClassifier('Groups', classgroups, 'PointModels', X, 'method', mth, 'params', params);
    XLS_DATA{1,3} = str;
    for j = 1:size(labels,2)
        XLS_DATA{idx,1} = pm_names{j};
        for k=1:size(labels,1)
            XLS_DATA{idx, 2*k} = classgroups(labels(k,j)).name;
            XLS_DATA{idx, 2*k +1} = d(k, j);
        end
        idx = idx + 1;
    end
end
return
%%%
%
%%%
function groups = selectGroups(str)
groups = [];
[filename, pathname] = uigetfile('*.mat', 'Open Group');
if isequal(filename,0) || isequal(pathname,0)
    disp('User pressed cancel');
    return
end
groups = load([pathname, filesep, filename]);
groups = groups.groups;
group_names = {groups.name};

[s,v] = listdlg('Name', 'Group Selection Window', 'PromptString',str,...
    'SelectionMode','Multiple', 'ListSize', [300 160],...
    'ListString',group_names);
if isempty(s)
    return;
end
groups = groups(s);
okflag = checkGroups(groups);

if any(okflag==0)
    bad_names = {groups(~okflag).name};
    fprintf('The Groups with no shape data are:\n');
    disp(bad_names);
    groups = [];
    msg = sprintf('There is no shape data in your group file. To correct this\nsimply open your groups, load the groups\n and then re-save the group.');
    uiwait(msgbox(msg,'Group Error','modal'));
end
return
%%%
%
%%%
function okflag = checkGroups(groups)
okflag = zeros(length(groups),1);
for i=1:length(groups)
    if isfield(groups(i), 'shapedata')
        if ~isempty(groups(i).shapedata)
            okflag(i) = 1;
        end
    end
end
return
%%%
%
%%%
function params = getAlgorithmParameters
params = {};
prompt={'Enter the standard deviation for each Gaussian:', ...
    'Enter the number of neighbours: '};
name='Param. Dlg.';
numlines=1;
defaultanswer={'2', '5'};
resp = inputdlg(prompt,name,numlines,defaultanswer);
params{1} = [];
params{2}.h = str2double(resp{1});
params{3}.K = str2double(resp{2});
params{4} = [];
return
