function plotH = PlotModel(A, template, handles, plotH, AAMwindow_flag)
if nargin<5
    AAMwindow_flag=0;
end
if length(plotH)>0
    plotH_lines=plotH{1};
    plotH_landmarks=plotH{2};
    plotH_labels=plotH{3};
else
    plotH_lines=[];
    plotH_landmarks=[];
    plotH_labels=[];
end
% if(any(plotH_lines))
%     if any(ishandle(plotH_lines))
%         delete(plotH_lines);
%     end
%     plotH_lines = [];
% end
% if(any(plotH_landmarks))
%     if any(ishandle(plotH_landmarks))
%         delete(plotH_landmarks);
%     end
%     plotH_landmarks = [];
% end
% if(any(plotH_labels))
%     if any(ishandle(plotH_labels))
%         delete(plotH_labels);
%     end
%     plotH_labels = [];
% end
I = get(template, 'image');
pts = get(template, 'pts');
%indices=handles.dat.editable_indices; 
if ~isempty(handles.dat.edit_indices)
    indices=intersect(handles.dat.edit_indices,handles.dat.indices);
else
    indices=handles.dat.indices;
end
if ~isempty(indices)
    pri = get(template, 'primaries');
    %pri_indices=handles.dat.editable_pri_indices; 
    if ~isempty(handles.dat.edit_indices)
        pri_indices=intersect(handles.dat.edit_indices,pri);
        pointsToMove=intersect(handles.dat.edit_indices,handles.dat.pointsToMove);
    else
        pri_indices=pri;
        pointsToMove=handles.dat.pointsToMove;
    end
    %pointsToMove=handles.dat.editable_pointsToMove; 
    loops = get(template, 'loops');
    closedloops = get(template, 'closedloops');
    % if AAMwindow_flag==0
    if isfield(handles.dat, 'pointsToMove')
        pts2move = handles.dat.pointsToMove;
    end
    closedloops = zeros(size(closedloops));
    if ~isempty(handles.dat.indices)
        pri = intersect(pri, handles.dat.indices);
    end
    if isempty(closedloops)
        closedloops = 0;
    end
    axes(A); hold(A, 'on');
    if get(handles.linesChk, 'value')
        kk_lines=1;
        if length(loops)==1
            edges = loops{1};
            for e = 1:size(edges,1)
                if ~isempty(handles.dat.edit_indices)
                    if ~isempty(intersect(edges(e,:),handles.dat.edit_indices))
                        if ~(exist('plotH_lines') & length(plotH_lines)>=kk_lines)
                            plotH_lines(kk_lines) = plot([pts(1, edges(e,1)),pts(1, edges(e,2))], ...
                                [pts(2, edges(e,1)),pts(2, edges(e,2))], '-r', 'LineWidth', 1.5,...
                                'MarkerEdgeColor', [112/255 91/255 223/255], 'HitTest', 'off');
                        else
                            set(plotH_lines(kk_lines),'XData',[pts(1, edges(e,1)),pts(1, edges(e,2))],'YData',[pts(2, edges(e,1)),pts(2, edges(e,2))]);
                        end
                        kk_lines=kk_lines+1;
                    end
                else
                    if ~(exist('plotH_lines') & length(plotH_lines)>=kk_lines)
                        plotH_lines(kk_lines) = plot([pts(1, edges(e,1)),pts(1, edges(e,2))], ...
                            [pts(2, edges(e,1)),pts(2, edges(e,2))], '-r', 'LineWidth', 1.5,...
                            'MarkerEdgeColor', [112/255 91/255 223/255], 'HitTest', 'off');
                    else
                        set(plotH_lines(kk_lines),'XData',[pts(1, edges(e,1)),pts(1, edges(e,2))],'YData',[pts(2, edges(e,1)),pts(2, edges(e,2))]);
                    end
                    kk_lines=kk_lines+1;
                end
            end
            if ~(exist('plotH_lines') & length(plotH_lines)>=kk_lines)
                plotH_lines(kk_lines) = plot(pts(1, indices), ...
                    pts(2,indices), '.r', 'HitTest', 'off', 'ButtonDownFcn', 'ls', 'Parent', A);
            else
                set(plotH_lines(kk_lines),'XData',pts(1, indices),'YData',pts(2,indices));
            end
            kk_lines=kk_lines+1;
            if ~(exist('plotH_lines') & length(plotH_lines)>=kk_lines)
                plotH_lines(kk_lines) = plot(pts(1, pri_indices), pts(2,pri_indices), '.g', 'HitTest', 'off', 'Parent', A);
            else
                set(plotH_lines(kk_lines),'XData',pts(1, pri_indices),'YData',pts(2,pri_indices));
            end
            kk_lines=kk_lines+1;
        end
    end
    if get(handles.landmarksChk, 'value')
        % Make sure that there are some points to plot and then plot them.
        kk_landmarks=1;
        if (size(pts, 2) > 0)
            if ~(exist('plotH_landmarks') & length(plotH_landmarks)>=kk_landmarks)
                plotH_landmarks(kk_landmarks) = plot(pts(1, indices), pts(2,indices), 'or',...
                    'MarkerEdgeColor', 'y', 'MarkerFaceColor', 'r', 'MarkerSize', 6, ...
                    'HitTest', 'off', 'ButtonDownFcn', 'ls', 'Parent', A);
            else
                set(plotH_landmarks(kk_landmarks),'XData',pts(1, indices),'YData',pts(2,indices));
            end
            kk_landmarks=kk_landmarks+1;
            %plotH(length(plotH)+1) = plot(pts(1, handles.dat.indices), pts(2,handles.dat.indices), 'or', 'MarkerEdgeColor', 'y', 'MarkerFaceColor', 'r', 'MarkerSize', 6, 'HitTest', 'off', 'ButtonDownFcn', 'ls', 'Parent', A);
        end

        % Plot any primary points in green
        if (length(pri)>0)
            if ~(exist('plotH_landmarks') & length(plotH_landmarks)>=kk_landmarks)
                plotH_landmarks(kk_landmarks) = plot(pts(1, pri_indices), pts(2, pri_indices),...
                    'og', 'MarkerEdgeColor', 'y', 'MarkerFaceColor', 'g', 'MarkerSize', 6, 'HitTest', 'off', 'Parent', A);
            else
                set(plotH_landmarks(kk_landmarks),'XData',pts(1, pri_indices),'YData',pts(2, pri_indices));
            end
            kk_landmarks=kk_landmarks+1;
        end
        % Make sure that there are some points to plot and then plot them.
        if isfield(handles.dat, 'pointsToMove')
            if (size(pts, 2) > 0) & (length(pointsToMove)>0)
                if ~(exist('plotH_landmarks') & length(plotH_landmarks)>=kk_landmarks)
                    plotH_landmarks(kk_landmarks) = plot(pts(1, pointsToMove), pts(2,pointsToMove), 'or', ...
                        'MarkerEdgeColor', 'k', 'MarkerFaceColor', 'none', 'MarkerSize', 6, ...
                        'HitTest', 'off', 'ButtonDownFcn', 'ls', 'Parent', A);
                else
                    set(plotH_landmarks(kk_landmarks),'XData',pts(1, pointsToMove),'YData',pts(2, pointsToMove));
                end
                kk_landmarks=kk_landmarks+1;
            end
        end

    end
    if get(handles.labelingChk, 'value')
        kk_labels=1;
        s= num2str(indices(:));
        if ~isfield(handles,'red')
            handles.red=1;
        end
        if ~(exist('plotH_labels') & length(plotH_labels)>=kk_labels)
            p = text(pts(1, indices), pts(2,indices), s, 'Color', 'r', 'HitTest', 'off', 'Clipping', 'on', 'Parent', A);
            plotH_labels = [plotH_labels, p'];
        else
            for i=1:length(indices)
                ii=kk_labels+i-1;
                set(plotH_labels(ii),'Position',[pts(1, indices(i)),pts(2, indices(i)),0 ]);
                %set(plotH_labels(ii),'Position',[pts(1, indices)',pts(2, indices)',zeros(size(pts(2, indices)'))]);
            end
        end
        kk_labels=kk_labels+length(s);
    end
   % if (handles.red==1)
        set(plotH_labels,'Color','k', 'BackgroundColor', 'w');
   % else
   %     set(plotH_labels,'Color','w');
   % end
    if get(handles.linesChk, 'value')
        set(plotH_lines,'Visible','on');
    else
        set(plotH_lines,'Visible','off');
    end
    if get(handles.landmarksChk, 'value')
        set(plotH_landmarks,'Visible','on');
    else
        set(plotH_landmarks,'Visible','off');
    end
    if get(handles.labelingChk, 'value')
        set(plotH_labels,'Visible','on');
    else
        set(plotH_labels,'Visible','off');
    end
end
plotH{1}=plotH_lines;
plotH{2}=plotH_landmarks;
plotH{3}=plotH_labels;
return;

function [plotH] = PlotModel_old(A, template, handles, plotH, AAMwindow_flag)
if nargin<5
    AAMwindow_flag=0;
end
if(any(plotH))
    if any(ishandle(plotH))
        delete(plotH);
    end
    plotH = [];
end
I = get(template, 'image');
pts = get(template, 'pts');
pri = get(template, 'primaries');
loops = get(template, 'loops');
closedloops = get(template, 'closedloops');
% if AAMwindow_flag==0
if isfield(handles.dat, 'pointsToMove')
    pts2move = handles.dat.pointsToMove;
end
closedloops = zeros(size(closedloops));
if ~isempty(handles.dat.indices)
    pri = intersect(pri, handles.dat.indices);
end
if isempty(closedloops)
    closedloops = 0;
end
axes(A); hold(A, 'on');
if get(handles.linesChk, 'value')

    if length(loops)==1
        edges = loops{1};
        for e = 1:size(edges,1)
            plotH(length(plotH)+1) = plot([pts(1, edges(e,1)),pts(1, edges(e,2))], [pts(2, edges(e,1)),pts(2, edges(e,2))], '-r', 'LineWidth', 1.5, 'MarkerEdgeColor', [112/255 91/255 223/255], 'HitTest', 'off');
        end
        plotH(length(plotH)+1) = plot(pts(1, handles.dat.indices), pts(2,handles.dat.indices), '.r', 'HitTest', 'off', 'ButtonDownFcn', 'ls', 'Parent', A);
        plotH(length(plotH)+1) = plot(pts(1, pri), pts(2,pri), '.g', 'HitTest', 'off', 'Parent', A);
    end

end
if get(handles.landmarksChk, 'value')
    % Make sure that there are some points to plot and then plot them.
    if (size(pts, 2) > 0)
        plotH(length(plotH)+1) = plot(pts(1, handles.dat.indices), pts(2,handles.dat.indices), 'or', 'MarkerEdgeColor', 'y', 'MarkerFaceColor', 'r', 'MarkerSize', 6, 'HitTest', 'off', 'ButtonDownFcn', 'ls', 'Parent', A);
        %plotH(length(plotH)+1) = plot(pts(1, handles.dat.indices), pts(2,handles.dat.indices), 'or', 'MarkerEdgeColor', 'y', 'MarkerFaceColor', 'r', 'MarkerSize', 6, 'HitTest', 'off', 'ButtonDownFcn', 'ls', 'Parent', A);
    end

    % Plot any primary points in green
    if (length(pri)>0)
        plotH(length(plotH)+1) = plot(pts(1, pri), pts(2,pri), 'og', 'MarkerEdgeColor', 'y', 'MarkerFaceColor', 'g', 'MarkerSize', 6, 'HitTest', 'off', 'Parent', A);
    end
    % Make sure that there are some points to plot and then plot them.
    if isfield(handles.dat, 'pointsToMove')
        if (size(pts, 2) > 0) & (length(handles.dat.pointsToMove)>0)
            plotH(length(plotH)+1) = plot(pts(1, handles.dat.pointsToMove), pts(2,handles.dat.pointsToMove), 'or', 'MarkerEdgeColor', 'k', 'MarkerFaceColor', 'none', 'MarkerSize', 6, 'HitTest', 'off', 'ButtonDownFcn', 'ls', 'Parent', A);
        end
    end

end
if get(handles.labelingChk, 'value')
    s= num2str(handles.dat.indices(:));
    if ~isfield(handles,'red')
        handles.red=1;
    end
    if handles.red==1
        p = text(pts(1, handles.dat.indices), pts(2,handles.dat.indices), s, 'Color', 'r', 'HitTest', 'off', 'Clipping', 'on', 'Parent', A);
    else
        p = text(pts(1, handles.dat.indices), pts(2,handles.dat.indices), s, 'Color', 'w', 'HitTest', 'off', 'Clipping', 'on', 'Parent', A);
    end
    plotH = [plotH, p'];
    %template = get(template, 'PointModelTemplate');
    if strcmp(class(template), 'PointModelTemplate')
        labels = get(template, 'labels');
        for l = 1:length(labels)
            v = labels(l).position;
            name = labels(l).name;
            if length(name)>0
                if handles.red==1
                    plotH(length(plotH)+1) = text(pts(1, v)+22, pts(2,v), name, 'Color', 'r', 'HitTest', 'off', 'Parent', A, 'Clipping', 'on');
                else
                    plotH(length(plotH)+1) = text(pts(1, v)+22, pts(2,v), name, 'Color', 'w', 'HitTest', 'off', 'Parent', A, 'Clipping', 'on');
                end
            end
        end
    end
end
return;


