function pcalib_plotshapematrix(X, c, axis_h)
% function pcalib_plotshapematrix(X, c, axis_h)
%
% A simple script to plot the shapes given in the matrix X.
%
% Inputs:
%  X - a matrix where each column is of the form x = [x_1, y_1, x_2, y_2, ..., x_N, y_N]';
%  c - the color to plot the shape (default: c = [0 0 1])
%  axis_h - the handle of the axis to plot the shape (default: axis_h = gca)
%
% Dr. A. I. Hanna (2006)
if nargin<2
    c = [0 0 1];
end
if nargin<3
    axis_h = gca;
end
hold(axis_h, 'on');
for i=1:size(X,2)
    x = X(:,i);
    pcalib_plotshape(x, c, axis_h);
end
hold(axis_h, 'off');