%
% 
% [Xm] = get_mean_shape_from_model(model_str)
%
% Parameters :
%   Input - 
%       model_str - this is a string pointing to the model.aam_dat that
%                   stores the mean shape data
%
%   Ouptput - 
%       Xm - this is a 2xN matrix where Xm(1,:) are the x coordinates and
%            Xm(2,:) are the y coordinates
%
% Example:
%
%       mean_shape = get_mean_shape_from_model('StatisticalModels/LeafTemplate_boundary_02/Set_1/ImageList_1/model.aam_dat');
%       plot(mean_shape(1,:), mean_shape(2,:),'.');
%       axis image;
%
% Dr. A. I. Hanna (2005)
%
function [Xm] = get_mean_shape_from_model(model_str)
    aam = load(model_str, '-mat');
    aam = aam.aam;
    pdm = get(aam, 'pdm');
    Xm = pdm.Xm;
    Xm = reshape(Xm, 2, length(Xm)/2);
    return;